/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class MoneyMarketAccount
extends AbstractLIBORMonteCarloProduct {
    private double inceptionTime = 0.0;
    private double initialValue = 1.0;
    private double accrualPeriod = -1.0;

    public MoneyMarketAccount(double d, double d2, double d3) {
        this.inceptionTime = d;
        this.initialValue = d2;
        this.accrualPeriod = d3;
    }

    public MoneyMarketAccount(double d, double d2) {
        this(d, 1.0, d2);
    }

    public MoneyMarketAccount() {
        this(0.0, 1.0, -1.0);
    }

    @Override
    public RandomVariableInterface getValue(double d, LIBORModelMonteCarloSimulationInterface lIBORModelMonteCarloSimulationInterface) throws CalculationException {
        if (this.inceptionTime > d) {
            return new RandomVariable(0.0);
        }
        if (this.accrualPeriod <= 0.0) {
            return new RandomVariable(Double.MAX_VALUE);
        }
        RandomVariableInterface randomVariableInterface = new RandomVariable(this.initialValue);
        for (double d2 = this.inceptionTime; d2 < d; d2 += this.accrualPeriod) {
            RandomVariableInterface randomVariableInterface2 = lIBORModelMonteCarloSimulationInterface.getLIBOR(d2, d2, d2 + this.accrualPeriod);
            double d3 = Math.min(this.accrualPeriod, d - d2);
            randomVariableInterface = randomVariableInterface.accrue(randomVariableInterface2, d3);
        }
        return randomVariableInterface;
    }
}

