/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.model.AbstractModelInterface;
import net.finmath.montecarlo.process.AbstractProcess;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORCovarianceModelStochasticVolatility
extends AbstractLIBORCovarianceModelParametric {
    private AbstractLIBORCovarianceModelParametric covarianceModel;
    private BrownianMotionInterface brownianMotion;
    private double rho;
    private double nu;
    private boolean isCalibrateable = false;
    private AbstractProcessInterface stochasticVolatilityScalings = null;

    public LIBORCovarianceModelStochasticVolatility(AbstractLIBORCovarianceModelParametric abstractLIBORCovarianceModelParametric, BrownianMotionInterface brownianMotionInterface, double d, double d2, boolean bl) {
        super(abstractLIBORCovarianceModelParametric.getTimeDiscretization(), abstractLIBORCovarianceModelParametric.getLiborPeriodDiscretization(), abstractLIBORCovarianceModelParametric.getNumberOfFactors());
        this.covarianceModel = abstractLIBORCovarianceModelParametric;
        this.brownianMotion = brownianMotionInterface;
        this.nu = d;
        this.rho = d2;
        this.isCalibrateable = bl;
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return this.covarianceModel.getParameter();
        }
        double[] dArray = this.covarianceModel.getParameter();
        if (dArray == null) {
            return new double[]{this.nu, this.rho};
        }
        double[] dArray2 = new double[dArray.length + 2];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        dArray2[dArray.length + 0] = this.nu;
        dArray2[dArray.length + 1] = this.rho;
        return dArray2;
    }

    @Override
    public void setParameter(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return;
        }
        if (!this.isCalibrateable) {
            this.covarianceModel.setParameter(dArray);
            return;
        }
        double[] dArray2 = new double[dArray.length - 2];
        System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
        this.covarianceModel.setParameter(dArray2);
        this.nu = dArray[dArray2.length + 0];
        this.rho = dArray[dArray2.length + 1];
        this.stochasticVolatilityScalings = null;
    }

    @Override
    public Object clone() {
        LIBORCovarianceModelStochasticVolatility lIBORCovarianceModelStochasticVolatility = new LIBORCovarianceModelStochasticVolatility((AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone(), this.brownianMotion, this.nu, this.rho, this.isCalibrateable);
        return lIBORCovarianceModelStochasticVolatility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface[] getFactorLoading(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray) {
        Object object = this;
        synchronized (object) {
            if (this.stochasticVolatilityScalings == null) {
                this.stochasticVolatilityScalings = new ProcessEulerScheme(this.brownianMotion);
                ((AbstractProcess)this.stochasticVolatilityScalings).setModel(new AbstractModelInterface(){

                    @Override
                    public void setProcess(AbstractProcessInterface abstractProcessInterface) {
                    }

                    @Override
                    public TimeDiscretizationInterface getTimeDiscretization() {
                        return LIBORCovarianceModelStochasticVolatility.this.brownianMotion.getTimeDiscretization();
                    }

                    @Override
                    public AbstractProcessInterface getProcess() {
                        return LIBORCovarianceModelStochasticVolatility.this.stochasticVolatilityScalings;
                    }

                    @Override
                    public RandomVariableInterface getNumeraire(double d) throws CalculationException {
                        return null;
                    }

                    @Override
                    public int getNumberOfFactors() {
                        return 2;
                    }

                    @Override
                    public int getNumberOfComponents() {
                        return 1;
                    }

                    @Override
                    public RandomVariableInterface[] getInitialState() {
                        return new RandomVariableInterface[]{LIBORCovarianceModelStochasticVolatility.this.brownianMotion.getRandomVariableForConstant(0.0)};
                    }

                    @Override
                    public RandomVariableInterface[] getFactorLoading(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray) {
                        return new RandomVariableInterface[]{LIBORCovarianceModelStochasticVolatility.this.brownianMotion.getRandomVariableForConstant(LIBORCovarianceModelStochasticVolatility.this.rho * LIBORCovarianceModelStochasticVolatility.this.nu), LIBORCovarianceModelStochasticVolatility.this.brownianMotion.getRandomVariableForConstant(Math.sqrt(1.0 - LIBORCovarianceModelStochasticVolatility.this.rho * LIBORCovarianceModelStochasticVolatility.this.rho) * LIBORCovarianceModelStochasticVolatility.this.nu)};
                    }

                    @Override
                    public RandomVariableInterface[] getDrift(int n, RandomVariableInterface[] randomVariableInterfaceArray, RandomVariableInterface[] randomVariableInterfaceArray2) {
                        return new RandomVariableInterface[]{LIBORCovarianceModelStochasticVolatility.this.brownianMotion.getRandomVariableForConstant(-0.5 * LIBORCovarianceModelStochasticVolatility.this.nu * LIBORCovarianceModelStochasticVolatility.this.nu)};
                    }

                    @Override
                    public RandomVariableInterface applyStateSpaceTransform(int n, RandomVariableInterface randomVariableInterface) {
                        return randomVariableInterface.exp();
                    }
                });
            }
        }
        object = null;
        try {
            object = this.stochasticVolatilityScalings.getProcessValue(n, 0);
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        RandomVariableInterface[] randomVariableInterfaceArray2 = null;
        if (object != null) {
            randomVariableInterfaceArray2 = this.covarianceModel.getFactorLoading(n, n2, randomVariableInterfaceArray);
            for (int i = 0; i < randomVariableInterfaceArray2.length; ++i) {
                randomVariableInterfaceArray2[i] = randomVariableInterfaceArray2[i].mult((RandomVariableInterface)object);
            }
        }
        return randomVariableInterfaceArray2;
    }

    @Override
    public RandomVariableInterface getFactorLoadingPseudoInverse(int n, int n2, int n3, RandomVariableInterface[] randomVariableInterfaceArray) {
        return null;
    }
}

