/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.functions.LinearAlgebra;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModel;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORCorrelationModelExponentialDecay
extends LIBORCorrelationModel {
    private final int numberOfFactors;
    private double a;
    private final boolean isCalibrateable;
    private double[][] correlationMatrix;
    private double[][] factorMatrix;

    public LIBORCorrelationModelExponentialDecay(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, int n, double d, boolean bl) {
        super(timeDiscretizationInterface, timeDiscretizationInterface2);
        this.numberOfFactors = n;
        this.a = d;
        this.isCalibrateable = bl;
        this.initialize(n, d);
    }

    public LIBORCorrelationModelExponentialDecay(TimeDiscretizationInterface timeDiscretizationInterface, TimeDiscretizationInterface timeDiscretizationInterface2, int n, double d) {
        super(timeDiscretizationInterface, timeDiscretizationInterface2);
        this.numberOfFactors = n;
        this.a = d;
        this.isCalibrateable = false;
        this.initialize(n, d);
    }

    @Override
    public void setParameter(double[] dArray) {
        if (!this.isCalibrateable) {
            return;
        }
        this.a = Math.abs(dArray[0]);
        this.initialize(this.numberOfFactors, this.a);
    }

    @Override
    public Object clone() {
        return new LIBORCorrelationModelExponentialDecay(this.timeDiscretization, this.liborPeriodDiscretization, this.numberOfFactors, this.a, this.isCalibrateable);
    }

    @Override
    public double getFactorLoading(int n, int n2, int n3) {
        return this.factorMatrix[n3][n2];
    }

    @Override
    public double getCorrelation(int n, int n2, int n3) {
        return this.correlationMatrix[n2][n3];
    }

    @Override
    public int getNumberOfFactors() {
        return this.factorMatrix[0].length;
    }

    private void initialize(int n, double d) {
        int n2;
        int n3;
        this.correlationMatrix = new double[this.liborPeriodDiscretization.getNumberOfTimeSteps()][this.liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (n3 = 0; n3 < this.correlationMatrix.length; ++n3) {
            for (n2 = 0; n2 < this.correlationMatrix[n3].length; ++n2) {
                this.correlationMatrix[n3][n2] = Math.exp(-d * Math.abs(this.liborPeriodDiscretization.getTime(n3) - this.liborPeriodDiscretization.getTime(n2)));
            }
        }
        this.factorMatrix = LinearAlgebra.factorReduction(this.correlationMatrix, n);
        for (n3 = 0; n3 < this.factorMatrix.length; ++n3) {
            for (n2 = 0; n2 < n3; ++n2) {
                double d2 = 0.0;
                for (int i = 0; i < this.factorMatrix[n3].length; ++i) {
                    d2 += this.factorMatrix[n3][i] * this.factorMatrix[n2][i];
                }
                this.correlationMatrix[n3][n2] = d2;
                this.correlationMatrix[n2][n3] = d2;
            }
            this.correlationMatrix[n3][n3] = 1.0;
        }
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        double[] dArray = new double[]{this.a};
        return dArray;
    }
}

