/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.process.AbstractProcess;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORModelMonteCarloSimulation
implements LIBORModelMonteCarloSimulationInterface {
    private final LIBORMarketModelInterface model;

    public LIBORModelMonteCarloSimulation(LIBORMarketModelInterface lIBORMarketModelInterface, AbstractProcess abstractProcess) {
        this.model = lIBORMarketModelInterface;
        this.model.setProcess(abstractProcess);
        abstractProcess.setModel(lIBORMarketModelInterface);
    }

    public LIBORModelMonteCarloSimulation(LIBORMarketModelInterface lIBORMarketModelInterface) {
        this.model = lIBORMarketModelInterface;
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(int n) throws CalculationException {
        return this.model.getProcess().getMonteCarloWeights(n);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double d) throws CalculationException {
        int n = this.getTimeIndex(d);
        if (n < 0) {
            n = -n - 1 - 1;
        }
        return this.model.getProcess().getMonteCarloWeights(n);
    }

    @Override
    public int getNumberOfFactors() {
        return this.model.getProcess().getNumberOfFactors();
    }

    @Override
    public int getNumberOfPaths() {
        return this.model.getProcess().getNumberOfPaths();
    }

    @Override
    public double getTime(int n) {
        return this.model.getProcess().getTime(n);
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.model.getProcess().getTimeDiscretization();
    }

    @Override
    public int getTimeIndex(double d) {
        return this.model.getProcess().getTimeIndex(d);
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double d) {
        return this.model.getProcess().getBrownianMotion().getRandomVariableForConstant(d);
    }

    @Override
    public BrownianMotionInterface getBrownianMotion() {
        return this.model.getProcess().getBrownianMotion();
    }

    @Override
    public RandomVariableInterface getLIBOR(int n, int n2) throws CalculationException {
        return this.model.getLIBOR(n, n2);
    }

    @Override
    public RandomVariableInterface[] getLIBORs(int n) throws CalculationException {
        RandomVariableInterface[] randomVariableInterfaceArray = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int i = 0; i < this.getNumberOfComponents(); ++i) {
            randomVariableInterfaceArray[i] = this.getLIBOR(n, i);
        }
        return randomVariableInterfaceArray;
    }

    @Override
    public RandomVariableInterface getLIBOR(double d, double d2, double d3) throws CalculationException {
        int n = this.getLiborPeriodIndex(d2);
        int n2 = this.getLiborPeriodIndex(d3);
        if (n2 < 0) {
            int n3 = -n2 - 1 - 1;
            double d4 = this.getLiborPeriod(n3);
            double d5 = this.getLiborPeriod(n3 + 1);
            RandomVariableInterface randomVariableInterface = this.getLIBOR(d, d2, d5);
            RandomVariableInterface randomVariableInterface2 = this.getLIBOR(d, d4, d5);
            RandomVariableInterface randomVariableInterface3 = randomVariableInterface.mult(d5 - d2).add(1.0).div(randomVariableInterface2.mult(d5 - d4).add(1.0).log().mult((d5 - d3) / (d5 - d4)).exp()).sub(1.0).div(d3 - d2);
            double d6 = this.model.getForwardRateCurve().getForward(this.model.getAnalyticModel(), d4, d3 - d4);
            double d7 = this.model.getForwardRateCurve().getForward(this.model.getAnalyticModel(), d4, d5 - d4);
            double d8 = (1.0 + d7 * (d5 - d4)) / Math.exp(Math.log(1.0 + d7 * (d5 - d4)) * (d5 - d3) / (d5 - d4));
            double d9 = 1.0 + d6 * (d3 - d4);
            double d10 = d9 / d8;
            randomVariableInterface3 = randomVariableInterface3.mult(d3 - d2).add(1.0).mult(d10).sub(1.0).div(d3 - d2);
            return randomVariableInterface3;
        }
        if (n < 0) {
            int n4 = -n - 1 - 1;
            double d11 = this.getLiborPeriod(n4);
            double d12 = this.getLiborPeriod(n4 + 1);
            RandomVariableInterface randomVariableInterface = this.getLIBOR(d, d11, d3);
            RandomVariableInterface randomVariableInterface4 = this.getLIBOR(d, d11, d12);
            RandomVariableInterface randomVariableInterface5 = randomVariableInterface.mult(d3 - d11).add(1.0).div(randomVariableInterface4.mult(d12 - d11).add(1.0).log().mult((d2 - d11) / (d12 - d11)).exp()).sub(1.0).div(d3 - d2);
            double d13 = this.model.getForwardRateCurve().getForward(this.model.getAnalyticModel(), d11, d12 - d2);
            double d14 = this.model.getForwardRateCurve().getForward(this.model.getAnalyticModel(), d11, d12 - d11);
            double d15 = (1.0 + d14 * (d12 - d11)) / Math.exp(Math.log(1.0 + d14 * (d12 - d11)) * (d12 - d2) / (d12 - d11));
            double d16 = 1.0 + d13 * (d2 - d11);
            double d17 = d16 / d15;
            randomVariableInterface5 = randomVariableInterface5.mult(d3 - d2).add(1.0).div(d17).sub(1.0).div(d3 - d2);
            return randomVariableInterface5;
        }
        if (n < 0 || n2 < 0) {
            throw new AssertionError((Object)"LIBOR requested outside libor discretization points and interpolation was not performed.");
        }
        int n5 = this.getTimeIndex(d = Math.min(d, d2));
        if (n5 < 0) {
            n5 = -n5 - 2;
        }
        if (n + 1 == n2) {
            return this.getLIBOR(n5, n);
        }
        RandomVariableInterface randomVariableInterface = this.getRandomVariableForConstant(1.0);
        for (int i = n; i < n2; ++i) {
            double d18 = this.getLiborPeriod(i + 1) - this.getLiborPeriod(i);
            RandomVariableInterface randomVariableInterface6 = this.getLIBOR(n5, i);
            randomVariableInterface = randomVariableInterface.accrue(randomVariableInterface6, d18);
        }
        RandomVariableInterface randomVariableInterface7 = randomVariableInterface.sub(1.0).div(d3 - d2);
        return randomVariableInterface7;
    }

    @Override
    public double getLiborPeriod(int n) {
        return this.model.getLiborPeriod(n);
    }

    @Override
    public TimeDiscretizationInterface getLiborPeriodDiscretization() {
        return this.model.getLiborPeriodDiscretization();
    }

    @Override
    public int getLiborPeriodIndex(double d) {
        return this.model.getLiborPeriodIndex(d);
    }

    public int getNumberOfComponents() {
        return this.model.getNumberOfComponents();
    }

    @Override
    public int getNumberOfLibors() {
        return this.model.getNumberOfLibors();
    }

    @Override
    public RandomVariableInterface getNumeraire(double d) throws CalculationException {
        return this.model.getNumeraire(d);
    }

    @Override
    public AbstractLIBORCovarianceModel getCovarianceModel() {
        return this.model.getCovarianceModel();
    }

    @Override
    public LIBORMarketModelInterface getModel() {
        return this.model;
    }

    @Override
    public AbstractProcessInterface getProcess() {
        return this.model.getProcess();
    }

    @Override
    public Object getCloneWithModifiedSeed(int n) {
        AbstractProcess abstractProcess = (AbstractProcess)((AbstractProcess)this.getProcess()).getCloneWithModifiedSeed(n);
        return new LIBORModelMonteCarloSimulation(this.model, abstractProcess);
    }

    @Override
    public LIBORModelMonteCarloSimulationInterface getCloneWithModifiedData(Map<String, Object> map) throws CalculationException {
        LIBORMarketModelInterface lIBORMarketModelInterface = this.model.getCloneWithModifiedData(map);
        if (map.containsKey("discountCurve") && map.size() == 1) {
            LIBORModelMonteCarloSimulation lIBORModelMonteCarloSimulation = new LIBORModelMonteCarloSimulation(lIBORMarketModelInterface);
            lIBORMarketModelInterface.setProcess(this.getProcess());
            return lIBORModelMonteCarloSimulation;
        }
        return new LIBORModelMonteCarloSimulation(lIBORMarketModelInterface, (AbstractProcess)this.getProcess().clone());
    }

    public LIBORModelMonteCarloSimulationInterface getCloneWithModifiedData(String string, Object object) throws CalculationException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(string, object);
        return this.getCloneWithModifiedData(hashMap);
    }
}

