/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.conditionalexpectation;

import net.finmath.functions.LinearAlgebra;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectation;
import net.finmath.stochastic.RandomVariableInterface;

public class MonteCarloConditionalExpectationRegression
implements MonteCarloConditionalExpectation {
    private RandomVariableInterface[] basisFunctionsEstimator = null;
    private RandomVariableInterface[] basisFunctionsPredictor = null;

    public MonteCarloConditionalExpectationRegression(RandomVariableInterface[] randomVariableInterfaceArray) {
        this.basisFunctionsEstimator = randomVariableInterfaceArray;
        this.basisFunctionsPredictor = randomVariableInterfaceArray;
    }

    public MonteCarloConditionalExpectationRegression(RandomVariableInterface[] randomVariableInterfaceArray, RandomVariableInterface[] randomVariableInterfaceArray2) {
        this.basisFunctionsEstimator = randomVariableInterfaceArray;
        this.basisFunctionsPredictor = randomVariableInterfaceArray2;
    }

    @Override
    public RandomVariableInterface getConditionalExpectation(RandomVariableInterface randomVariableInterface) {
        double[] dArray = this.getLinearRegressionParameters(randomVariableInterface);
        RandomVariableInterface[] randomVariableInterfaceArray = this.getNonZeroBasisFunctions(this.basisFunctionsPredictor);
        RandomVariableInterface randomVariableInterface2 = randomVariableInterfaceArray[0].mult(dArray[0]);
        for (int i = 1; i < randomVariableInterfaceArray.length; ++i) {
            randomVariableInterface2 = randomVariableInterface2.addProduct(randomVariableInterfaceArray[i], dArray[i]);
        }
        return randomVariableInterface2;
    }

    public double[] getLinearRegressionParameters(RandomVariableInterface randomVariableInterface) {
        int n;
        RandomVariableInterface[] randomVariableInterfaceArray = this.getNonZeroBasisFunctions(this.basisFunctionsEstimator);
        double[][] dArray = new double[randomVariableInterfaceArray.length][randomVariableInterfaceArray.length];
        for (int i = 0; i < randomVariableInterfaceArray.length; ++i) {
            for (n = i; n < randomVariableInterfaceArray.length; ++n) {
                dArray[i][n] = randomVariableInterfaceArray[i].getAverage(randomVariableInterfaceArray[n]);
                dArray[n][i] = dArray[i][n];
            }
        }
        double[] dArray2 = new double[randomVariableInterfaceArray.length];
        for (n = 0; n < randomVariableInterfaceArray.length; ++n) {
            dArray2[n] = randomVariableInterface.getAverage(randomVariableInterfaceArray[n]);
        }
        double[] dArray3 = LinearAlgebra.solveLinearEquationLeastSquare(dArray, dArray2);
        return dArray3;
    }

    private RandomVariableInterface[] getNonZeroBasisFunctions(RandomVariableInterface[] randomVariableInterfaceArray) {
        int n = 0;
        for (int i = 0; i < randomVariableInterfaceArray.length; ++i) {
            if (randomVariableInterfaceArray[i] == null) continue;
            ++n;
        }
        RandomVariableInterface[] randomVariableInterfaceArray2 = new RandomVariableInterface[n];
        int n2 = 0;
        for (RandomVariableInterface randomVariableInterface : randomVariableInterfaceArray) {
            if (randomVariableInterface == null) continue;
            randomVariableInterfaceArray2[n2] = randomVariableInterface;
            ++n2;
        }
        return randomVariableInterfaceArray2;
    }
}

