/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.ArrayList;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.montecarlo.process.AbstractProcess;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class MonteCarloBlackScholesModel
extends AbstractModel
implements AssetModelMonteCarloSimulationInterface {
    private final double initialValue;
    private final double riskFreeRate;
    private final double volatility;
    private final int seed = 3141;
    private final RandomVariableInterface[] initialValueVector = new RandomVariableInterface[1];
    private final RandomVariableInterface drift;
    private final RandomVariableInterface volatilityOnPaths;

    public MonteCarloBlackScholesModel(TimeDiscretizationInterface timeDiscretizationInterface, int n, double d, double d2, double d3) {
        this.initialValue = d;
        this.riskFreeRate = d2;
        this.volatility = d3;
        ProcessEulerScheme processEulerScheme = new ProcessEulerScheme(new BrownianMotion(timeDiscretizationInterface, 1, n, 3141));
        this.initialValueVector[0] = processEulerScheme.getBrownianMotion().getRandomVariableForConstant(Math.log(d));
        this.drift = processEulerScheme.getBrownianMotion().getRandomVariableForConstant(d2 - d3 * d3 / 2.0);
        this.volatilityOnPaths = processEulerScheme.getBrownianMotion().getRandomVariableForConstant(d3);
        processEulerScheme.setModel(this);
        this.setProcess(processEulerScheme);
    }

    public MonteCarloBlackScholesModel(double d, double d2, double d3, AbstractProcess abstractProcess) {
        this.initialValue = d;
        this.riskFreeRate = d2;
        this.volatility = d3;
        this.initialValueVector[0] = abstractProcess.getBrownianMotion().getRandomVariableForConstant(Math.log(d));
        this.drift = abstractProcess.getBrownianMotion().getRandomVariableForConstant(d2 - 0.5 * d3 * d3);
        this.volatilityOnPaths = abstractProcess.getBrownianMotion().getRandomVariableForConstant(d3);
        abstractProcess.setModel(this);
        this.setProcess(abstractProcess);
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        return this.initialValueVector;
    }

    @Override
    public RandomVariableInterface[] getDrift(int n, RandomVariableInterface[] randomVariableInterfaceArray, RandomVariableInterface[] randomVariableInterfaceArray2) {
        return new RandomVariableInterface[]{this.drift};
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray) {
        return new RandomVariableInterface[]{this.volatilityOnPaths};
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int n, RandomVariableInterface randomVariableInterface) {
        return randomVariableInterface.exp();
    }

    @Override
    public RandomVariableInterface getAssetValue(double d, int n) throws CalculationException {
        return this.getAssetValue(this.getTimeIndex(d), n);
    }

    @Override
    public RandomVariableInterface getAssetValue(int n, int n2) throws CalculationException {
        return this.getProcessValue(n, n2);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double d) throws CalculationException {
        return this.getMonteCarloWeights(this.getTimeIndex(d));
    }

    @Override
    public RandomVariableInterface getNumeraire(int n) {
        double d = this.getTime(n);
        return this.getNumeraire(d);
    }

    @Override
    public RandomVariableInterface getNumeraire(double d) {
        double d2 = Math.exp(this.riskFreeRate * d);
        return this.getRandomVariableForConstant(d2);
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double d) {
        return this.getProcess().getBrownianMotion().getRandomVariableForConstant(d);
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public int getNumberOfAssets() {
        return 1;
    }

    public String toString() {
        return super.toString() + "\n" + "MonteCarloBlackScholesModel:\n" + "  initial value...:" + this.initialValue + "\n" + "  risk free rate..:" + this.riskFreeRate + "\n" + "  volatiliy.......:" + this.volatility;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double getVolatility() {
        return this.volatility;
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedData(Map<String, Object> map) {
        ArrayList<Double> arrayList;
        double d = map.get("initialTime") != null ? ((Number)map.get("initialTime")).doubleValue() : this.getTime(0);
        double d2 = map.get("initialValue") != null ? ((Number)map.get("initialValue")).doubleValue() : this.initialValue;
        double d3 = map.get("riskFreeRate") != null ? ((Number)map.get("riskFreeRate")).doubleValue() : this.riskFreeRate;
        double d4 = map.get("volatility") != null ? ((Number)map.get("volatility")).doubleValue() : this.volatility;
        int n = map.get("seed") != null ? ((Number)map.get("seed")).intValue() : 3141;
        BrownianMotionInterface brownianMotionInterface = map.get("seed") != null ? new BrownianMotion(this.getTimeDiscretization(), 1, this.getNumberOfPaths(), n) : this.getProcess().getBrownianMotion();
        double d5 = d - this.getTime(0);
        if (d5 != 0.0) {
            arrayList = new ArrayList<Double>();
            arrayList.add(d);
            for (Double d6 : this.getProcess().getBrownianMotion().getTimeDiscretization()) {
                if (!(d6 > d)) continue;
                arrayList.add(d6);
            }
            TimeDiscretization timeDiscretization = new TimeDiscretization(arrayList);
            brownianMotionInterface = brownianMotionInterface.getCloneWithModifiedTimeDiscretization(timeDiscretization);
        }
        arrayList = new ProcessEulerScheme(brownianMotionInterface);
        return new MonteCarloBlackScholesModel(d2, d3, d4, (AbstractProcess)((Object)arrayList));
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedSeed(int n) {
        ProcessEulerScheme processEulerScheme = new ProcessEulerScheme(new BrownianMotion(this.getTimeDiscretization(), 1, this.getNumberOfPaths(), n));
        return new MonteCarloBlackScholesModel(this.initialValue, this.riskFreeRate, this.volatility, processEulerScheme);
    }

    @Override
    public int getNumberOfPaths() {
        return this.getProcess().getNumberOfPaths();
    }
}

