/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.util.Arrays;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class BrownianBridge
implements BrownianMotionInterface {
    private final TimeDiscretizationInterface timeDiscretization;
    private final int numberOfFactors;
    private final int numberOfPaths;
    private final int seed;
    private RandomVariableInterface[] start;
    private RandomVariableInterface[] end;
    private AbstractRandomVariableFactory randomVariableFactory = new RandomVariableFactory();
    private transient RandomVariableInterface[][] brownianIncrements;
    private final Object brownianIncrementsLazyInitLock = new Object();

    public BrownianBridge(TimeDiscretizationInterface timeDiscretizationInterface, int n, int n2, RandomVariableInterface[] randomVariableInterfaceArray, RandomVariableInterface[] randomVariableInterfaceArray2) {
        this.timeDiscretization = timeDiscretizationInterface;
        this.numberOfFactors = randomVariableInterfaceArray.length;
        this.numberOfPaths = n;
        this.seed = n2;
        this.start = randomVariableInterfaceArray;
        this.end = randomVariableInterfaceArray2;
    }

    public BrownianBridge(TimeDiscretizationInterface timeDiscretizationInterface, int n, int n2, RandomVariableInterface randomVariableInterface, RandomVariableInterface randomVariableInterface2) {
        this(timeDiscretizationInterface, n, n2, new RandomVariableInterface[]{randomVariableInterface}, new RandomVariableInterface[]{randomVariableInterface2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getBrownianIncrement(int n, int n2) {
        Object object = this.brownianIncrementsLazyInitLock;
        synchronized (object) {
            if (this.brownianIncrements == null) {
                this.doGenerateBrownianMotion();
            }
        }
        return this.brownianIncrements[n][n2];
    }

    private void doGenerateBrownianMotion() {
        if (this.brownianIncrements != null) {
            return;
        }
        BrownianMotion brownianMotion = new BrownianMotion(this.timeDiscretization, this.numberOfFactors, this.numberOfPaths, this.seed);
        this.brownianIncrements = new RandomVariableInterface[brownianMotion.getTimeDiscretization().getNumberOfTimeSteps()][brownianMotion.getNumberOfFactors()];
        double d = this.getTimeDiscretization().getTime(this.getTimeDiscretization().getNumberOfTimeSteps());
        for (int i = 0; i < brownianMotion.getNumberOfFactors(); ++i) {
            RandomVariableInterface randomVariableInterface = this.end[i];
            RandomVariableInterface randomVariableInterface2 = this.start[i];
            for (int j = 0; j < this.getTimeDiscretization().getNumberOfTimeSteps(); ++j) {
                double d2 = this.getTimeDiscretization().getTime(j);
                double d3 = this.getTimeDiscretization().getTime(j + 1);
                double d4 = (d3 - d2) / (d - d2);
                RandomVariableInterface randomVariableInterface3 = randomVariableInterface2.mult(1.0 - d4).add(randomVariableInterface.mult(d4)).add(brownianMotion.getBrownianIncrement(j, i).mult(Math.sqrt(1.0 - d4)));
                this.brownianIncrements[j][i] = randomVariableInterface3.sub(randomVariableInterface2);
                randomVariableInterface2 = randomVariableInterface3;
            }
        }
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    @Override
    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double d) {
        return this.randomVariableFactory.createRandomVariable(d);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedSeed(int n) {
        return new BrownianBridge(this.timeDiscretization, this.numberOfPaths, n, this.start, this.end);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedTimeDiscretization(TimeDiscretizationInterface timeDiscretizationInterface) {
        return new BrownianBridge(timeDiscretizationInterface, this.getNumberOfFactors(), this.seed, this.start, this.end);
    }

    public String toString() {
        return "BrownianBridge [timeDiscretization=" + this.timeDiscretization + ", numberOfFactors=" + this.numberOfFactors + ", numberOfPaths=" + this.numberOfPaths + ", seed=" + this.seed + ", start=" + Arrays.toString(this.start) + ", end=" + Arrays.toString(this.end) + "]";
    }
}

