/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;

public class Portfolio
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private ArrayList<AnalyticProductInterface> products = new ArrayList();
    private ArrayList<Double> weights = new ArrayList();
    private static final int chunkSize = 20;
    private static final int numberOfThreads = 32;
    private static ExecutorService executorService = Executors.newFixedThreadPool(32, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });

    public Portfolio(List<AnalyticProductInterface> list, List<Double> list2) {
        this.products.addAll(list);
        this.weights.addAll(list2);
    }

    public Portfolio(Portfolio portfolio, List<AnalyticProductInterface> list, List<Double> list2) {
        this.products.addAll(portfolio.getProducts());
        this.weights.addAll(portfolio.getWeights());
        this.products.addAll(list);
        this.weights.addAll(list2);
    }

    public Portfolio(AnalyticProductInterface analyticProductInterface, double d) {
        this.products.add(analyticProductInterface);
        this.weights.add(d);
    }

    public Portfolio(List<AnalyticProductInterface> list) {
        this(list, Collections.nCopies(list.size(), new Double(1.0)));
    }

    @Override
    public double getValue(final double d, final AnalyticModelInterface analyticModelInterface) {
        int n;
        double d2 = 0.0;
        if (this.products.size() < 60) {
            for (int i = 0; i < this.products.size(); ++i) {
                d2 += this.weights.get(i) * this.products.get(i).getValue(d, analyticModelInterface);
            }
            return d2;
        }
        ArrayList<Future<Double>> arrayList = new ArrayList<Future<Double>>();
        for (n = 0; n < this.products.size(); n += 20) {
            final int n2 = n;
            arrayList.add(n / 20, executorService.submit(new Callable<Double>(){

                @Override
                public Double call() {
                    double d2 = 0.0;
                    for (int i = n2; i < Math.min(Portfolio.this.products.size(), n2 + 20); ++i) {
                        d2 += (Double)Portfolio.this.weights.get(i) * ((AnalyticProductInterface)Portfolio.this.products.get(i)).getValue(d, analyticModelInterface);
                    }
                    return d2;
                }
            }));
        }
        try {
            for (n = 0; n < arrayList.size(); ++n) {
                d2 += ((Double)((Future)arrayList.get(n)).get()).doubleValue();
            }
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException.getCause() instanceof RuntimeException ? (RuntimeException)interruptedException.getCause() : new RuntimeException(interruptedException.getCause());
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause() instanceof RuntimeException ? (RuntimeException)executionException.getCause() : new RuntimeException(executionException.getCause());
        }
        return d2;
    }

    public List<AnalyticProductInterface> getProducts() {
        return Collections.unmodifiableList(this.products);
    }

    public List<Double> getWeights() {
        return Collections.unmodifiableList(this.weights);
    }
}

