/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.CapletVolatilities;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;
import org.junit.Assert;
import org.junit.Test;

public class CapletVolatilitiesTest {
    @Test
    public void testConversions() {
        double[] dArray;
        double[] dArray2 = new double[]{0.0, 1.0, 2.0, 10.0};
        double[] dArray3 = new double[]{0.02, 0.02, 0.02, 0.02};
        double d = 0.25;
        ForwardCurve forwardCurve = ForwardCurve.createForwardCurveFromForwards("EUR 3M", dArray2, dArray3, d);
        double[] dArray4 = new double[]{0.0, 1.0, 2.0, 10.0};
        double[] dArray5 = new double[]{0.02, 0.02, 0.02, 0.02};
        double[] dArray6 = new double[]{0.2, 0.2, 0.2, 0.2};
        VolatilitySurfaceInterface.QuotingConvention quotingConvention = VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL;
        double[] dArray7 = new double[]{0.0, 1.0, 2.0, 10.0};
        double[] dArray8 = new double[]{1.0, 0.98, 0.96, 0.9};
        DiscountCurve discountCurve = DiscountCurve.createDiscountCurveFromDiscountFactors("EUR OIS", dArray7, dArray8);
        CapletVolatilities capletVolatilities = new CapletVolatilities("EUR Caplet", null, forwardCurve, dArray4, dArray5, dArray6, quotingConvention, discountCurve);
        double d2 = 1.0;
        double[] dArray9 = new double[]{0.001, 0.005, 0.01, 0.015, 0.018, 0.02, 0.022, 0.05, 0.1};
        for (double d3 : dArray = new double[]{0.01, 0.05, 0.1, 0.15, 0.2, 0.25, 0.5, 1.0}) {
            for (double d4 : dArray9) {
                System.out.println("Testing:\t Stike = " + d4 + "\tImplied Volatility = " + d3);
                double d5 = capletVolatilities.convertFromTo(d2, d4, d3, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL, VolatilitySurfaceInterface.QuotingConvention.PRICE);
                double d6 = capletVolatilities.convertFromTo(d2, d4, d5, VolatilitySurfaceInterface.QuotingConvention.PRICE, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
                double d7 = capletVolatilities.convertFromTo(d2, d4, d5, VolatilitySurfaceInterface.QuotingConvention.PRICE, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYNORMAL);
                double d8 = capletVolatilities.convertFromTo(d2, d4, d3, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYNORMAL);
                double d9 = capletVolatilities.convertFromTo(d2, d4, d8, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYNORMAL, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
                double d10 = capletVolatilities.convertFromTo(d2, d4, d7, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYNORMAL, VolatilitySurfaceInterface.QuotingConvention.PRICE);
                Assert.assertEquals((String)"Price deviation", (double)0.0, (double)((d5 - d10) / (1.0 + Math.abs(d5 - d10))), (double)1.0E-10);
                Assert.assertEquals((String)"Implied log-normal volatility deviation", (double)0.0, (double)((d6 - d9) / (1.0 + Math.abs(d6 - d9))), (double)1.0E-10);
                Assert.assertEquals((String)"Implied normal volatility deviation", (double)0.0, (double)((d7 - d8) / (1.0 + Math.abs(d7 - d8))), (double)1.0E-10);
            }
        }
    }
}

