/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.GregorianCalendar;
import java.util.Locale;
import net.finmath.marketdata.model.volatilities.CapletVolatilitiesParametric;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;
import org.junit.Assert;
import org.junit.Test;

public class CapletVolatilitiesParametricTest {
    private static DecimalFormat formatterMaturity = new DecimalFormat("00.00", new DecimalFormatSymbols(Locale.ENGLISH));
    private static DecimalFormat formatterValue = new DecimalFormat("  ##0.000%;-##0.000%", new DecimalFormatSymbols(Locale.ENGLISH));
    private static DecimalFormat formatterDeviation = new DecimalFormat(" 0.00000E00;-0.00000E00", new DecimalFormatSymbols(Locale.ENGLISH));

    @Test
    public void testFlatVolatilityUsingD() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.4;
        CapletVolatilitiesParametric capletVolatilitiesParametric = new CapletVolatilitiesParametric("flat", gregorianCalendar, d, d2, d3, d4);
        double d5 = 2.0;
        double d6 = 0.03;
        double d7 = capletVolatilitiesParametric.getValue(d5, d6, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
        Assert.assertTrue((d7 - d4 < 1.0E-15 ? 1 : 0) != 0);
    }

    @Test
    public void testFlatVolatilityUsingA() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        double d = 0.4;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        CapletVolatilitiesParametric capletVolatilitiesParametric = new CapletVolatilitiesParametric("flat", gregorianCalendar, d, d2, d3, d4);
        double d5 = 2.0;
        double d6 = 0.03;
        double d7 = capletVolatilitiesParametric.getValue(d5, d6, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
        Assert.assertTrue((d7 - d < 1.0E-15 ? 1 : 0) != 0);
    }

    @Test
    public void testDecayVolatility() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        double d = 0.1;
        double d2 = 0.0;
        double d3 = 0.2;
        double d4 = 0.0;
        CapletVolatilitiesParametric capletVolatilitiesParametric = new CapletVolatilitiesParametric("flat", gregorianCalendar, d, d2, d3, d4);
        double d5 = 2.0;
        double d6 = 0.03;
        double d7 = capletVolatilitiesParametric.getValue(d5, d6, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
        Assert.assertTrue((d7 - d * Math.sqrt((1.0 - Math.exp(-2.0 * d3 * d5)) / (2.0 * d3 * d5)) < 1.0E-15 ? 1 : 0) != 0);
    }

    @Test
    public void testIntegratedFourParameterExponentialVolatilityParamSet1() {
        double d = 0.25;
        double d2 = 3.0;
        double d3 = 1.5;
        double d4 = 0.1;
        this.testIntegratedFourParameterExponentialVolatility(d, d2, d3, d4);
    }

    @Test
    public void testIntegratedFourParameterExponentialVolatilityParamSetCZero() {
        double d = 0.25;
        double d2 = 0.02;
        double d3 = 0.0;
        double d4 = 0.1;
        this.testIntegratedFourParameterExponentialVolatility(d, d2, d3, d4);
    }

    private void testIntegratedFourParameterExponentialVolatility(double d, double d2, double d3, double d4) {
        System.out.println("Comparing finite difference differentiation of integrated variance with analytic value:\n");
        System.out.println("  t  \t analytic \t finite diff \t deviation ");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        CapletVolatilitiesParametric capletVolatilitiesParametric = new CapletVolatilitiesParametric("volSurface", gregorianCalendar, d, d2, d3, d4);
        double d5 = 0.0;
        for (double d6 = 0.01; d6 <= 10.0; d6 += 0.01) {
            double d7 = capletVolatilitiesParametric.getValue(d6 + 1.0E-5, 0.0, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
            double d8 = capletVolatilitiesParametric.getValue(d6 - 1.0E-5, 0.0, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
            double d9 = d7 * d7 * (d6 + 1.0E-5);
            double d10 = d8 * d8 * (d6 - 1.0E-5);
            double d11 = (d9 - d10) / 2.0E-5;
            double d12 = (d + d2 * d6) * Math.exp(-d3 * d6) + d4;
            double d13 = d12 * d12;
            double d14 = d13 - d11;
            System.out.print(formatterMaturity.format(d6) + "\t");
            System.out.print(formatterValue.format(d13) + "\t");
            System.out.print(formatterValue.format(d11) + "\t");
            System.out.print(formatterDeviation.format(d13 - d11) + "\n");
            d5 = Math.max(d5, Math.abs(d14));
        }
        System.out.println("Maximum abs deviation: " + formatterDeviation.format(d5));
        System.out.println("__________________________________________________________________________________________\n");
        Assert.assertEquals((String)"Deviation", (double)0.0, (double)d5, (double)1.0E-8);
    }
}

