/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.util.Calendar;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurface;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class CapletVolatilitiesParametricFourParameterPicewiseConstant
extends AbstractVolatilitySurface {
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final TimeDiscretizationInterface timeDiscretization;

    public CapletVolatilitiesParametricFourParameterPicewiseConstant(String string, Calendar calendar, double d, double d2, double d3, double d4, TimeDiscretizationInterface timeDiscretizationInterface) {
        super(string, calendar);
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.timeDiscretization = timeDiscretizationInterface;
        this.quotingConvention = VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL;
    }

    @Override
    public double getValue(double d, double d2, VolatilitySurfaceInterface.QuotingConvention quotingConvention) {
        return this.getValue(null, d, d2, quotingConvention);
    }

    @Override
    public double getValue(AnalyticModelInterface analyticModelInterface, double d, double d2, VolatilitySurfaceInterface.QuotingConvention quotingConvention) {
        double d3;
        if (d == 0.0) {
            return 0.0;
        }
        double d4 = 0.0;
        for (int i = 0; i < this.timeDiscretization.getNumberOfTimeSteps() && !((d3 = this.timeDiscretization.getTime(i)) > d); ++i) {
            double d5 = this.timeDiscretization.getTimeStep(i);
            double d6 = (this.a + this.b * (d - d3)) * Math.exp(-this.c * (d - d3)) + this.d;
            d4 += d6 * d6 * Math.min(d - d3, d5);
        }
        double d7 = Math.sqrt(d4 / d);
        return this.convertFromTo(analyticModelInterface, d, d2, d7, this.quotingConvention, quotingConvention);
    }
}

