/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurface;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class CapletVolatilities
extends AbstractVolatilitySurface {
    private Map<Double, CurveInterface> capletVolatilities = new HashMap<Double, CurveInterface>();
    private transient TimeDiscretizationInterface maturities;
    private Object lazyInitLock = new Object();

    public CapletVolatilities(String string, Calendar calendar, ForwardCurveInterface forwardCurveInterface, double[] dArray, double[] dArray2, double[] dArray3, VolatilitySurfaceInterface.QuotingConvention quotingConvention, DiscountCurveInterface discountCurveInterface) {
        super(string, calendar);
        this.forwardCurve = forwardCurveInterface;
        this.discountCurve = discountCurveInterface;
        this.quotingConvention = quotingConvention;
        if (dArray.length != dArray2.length || dArray.length != dArray3.length) {
            throw new IllegalArgumentException("Length of vectors is not equal.");
        }
        for (int i = 0; i < dArray3.length; ++i) {
            double d = dArray[i];
            double d2 = dArray2[i];
            double d3 = dArray3[i];
            this.add(d, d2, d3);
        }
    }

    private CapletVolatilities(String string, Calendar calendar) {
        super(string, calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(double d, double d2, double d3) {
        CurveInterface curveInterface = this.capletVolatilities.get(d);
        try {
            curveInterface = curveInterface == null ? new Curve.CurveBuilder().addPoint(d2, d3, true).build() : curveInterface.getCloneBuilder().addPoint(d2, d3, true).build();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Unable to build curve.");
        }
        Object object = this.lazyInitLock;
        synchronized (object) {
            this.capletVolatilities.put(d, curveInterface);
            this.maturities = null;
        }
    }

    @Override
    public double getValue(double d, double d2, VolatilitySurfaceInterface.QuotingConvention quotingConvention) {
        return this.getValue(null, d, d2, quotingConvention);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getValue(AnalyticModelInterface analyticModelInterface, double d, double d2, VolatilitySurfaceInterface.QuotingConvention quotingConvention) {
        double d3;
        if (d == 0.0) {
            return 0.0;
        }
        if (this.capletVolatilities.containsKey(d)) {
            d3 = this.capletVolatilities.get(d).getValue(d2);
        } else {
            Object object = this.lazyInitLock;
            synchronized (object) {
                if (this.maturities == null) {
                    this.maturities = new TimeDiscretization(this.capletVolatilities.keySet().toArray(new Double[0]));
                }
            }
            double d4 = this.maturities.getTime(Math.min(this.maturities.getTimeIndexNearestGreaterOrEqual(d), this.maturities.getNumberOfTimes() - 1));
            double d5 = this.forwardCurve.getValue(analyticModelInterface, d4) + (d2 - this.forwardCurve.getValue(analyticModelInterface, d));
            d3 = this.capletVolatilities.get(d4).getValue(d5);
        }
        return this.convertFromTo(analyticModelInterface, d, d2, d3, this.quotingConvention, quotingConvention);
    }

    public static AbstractVolatilitySurface fromFile(File file) throws FileNotFoundException {
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            while ((object = bufferedReader.readLine()) != null) {
                if (!((String)object).startsWith("caplet\t")) continue;
                arrayList.add(object);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = new CapletVolatilities(null, null);
        for (int i = 0; i < arrayList.size(); ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)arrayList.get(i), "\t");
            try {
                stringTokenizer.nextToken();
                double d = Double.parseDouble(stringTokenizer.nextToken());
                double d2 = Double.parseDouble(stringTokenizer.nextToken());
                double d3 = Double.parseDouble(stringTokenizer.nextToken());
                super.add(d, d2, d3);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return object;
    }
}

