/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.util.Calendar;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.CurveInterface;

public class SeasonalCurve
extends AbstractCurve
implements CurveInterface {
    private CurveInterface baseCurve;

    public SeasonalCurve(String string, Calendar calendar, CurveInterface curveInterface) {
        super(string, calendar);
        this.baseCurve = curveInterface;
    }

    @Override
    public double[] getParameter() {
        return this.baseCurve.getParameter();
    }

    @Override
    public void setParameter(double[] dArray) {
        this.baseCurve.setParameter(dArray);
    }

    @Override
    public double getValue(AnalyticModelInterface analyticModelInterface, double d) {
        Calendar calendar = (Calendar)this.getReferenceDate().clone();
        calendar.add(6, (int)Math.round(d * 365.0));
        int n = calendar.get(2);
        int n2 = calendar.get(5);
        int n3 = calendar.getActualMaximum(5);
        double d2 = (double)n / 12.0 + (double)(n2 - 1) / (double)n3 / 12.0;
        return this.baseCurve.getValue(analyticModelInterface, d2);
    }

    @Override
    public CurveInterface getCloneForParameter(double[] dArray) throws CloneNotSupportedException {
        SeasonalCurve seasonalCurve = this.clone();
        seasonalCurve.baseCurve = this.baseCurve.getCloneForParameter(dArray);
        return seasonalCurve;
    }

    @Override
    public SeasonalCurve clone() throws CloneNotSupportedException {
        return new SeasonalCurve(this.getName(), this.getReferenceDate(), (CurveInterface)this.baseCurve.clone());
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        return new CurveBuilder(this);
    }

    public static class CurveBuilder
    extends Curve.CurveBuilder
    implements CurveBuilderInterface {
        private SeasonalCurve curve = null;

        public CurveBuilder(SeasonalCurve seasonalCurve) throws CloneNotSupportedException {
            super((Curve)seasonalCurve.baseCurve);
            this.curve = seasonalCurve;
        }

        @Override
        public CurveInterface build() throws CloneNotSupportedException {
            SeasonalCurve seasonalCurve = this.curve.clone();
            seasonalCurve.baseCurve = super.build();
            this.curve = null;
            return seasonalCurve;
        }
    }
}

