/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.util.Calendar;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractForwardCurve;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingWeekends;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;

public class ForwardCurveFromDiscountCurve
extends AbstractForwardCurve
implements Serializable {
    private static final long serialVersionUID = -4126228588123963885L;
    private final double daycountScaling;
    private final double periodOffset;

    public ForwardCurveFromDiscountCurve(String string, String string2, Calendar calendar, String string3, BusinessdayCalendarInterface businessdayCalendarInterface, BusinessdayCalendarInterface.DateRollConvention dateRollConvention, double d, double d2) {
        super(string, calendar, string3, businessdayCalendarInterface, dateRollConvention, string2);
        this.daycountScaling = d;
        this.periodOffset = d2;
    }

    public ForwardCurveFromDiscountCurve(String string, String string2, Calendar calendar, String string3, BusinessdayCalendarInterface businessdayCalendarInterface, BusinessdayCalendarInterface.DateRollConvention dateRollConvention) {
        super(string, calendar, string3, businessdayCalendarInterface, dateRollConvention, string2);
        this.daycountScaling = 1.0;
        this.periodOffset = 0.0;
    }

    public ForwardCurveFromDiscountCurve(String string, String string2, Calendar calendar, String string3) {
        super(string, calendar, string3, new BusinessdayCalendarExcludingWeekends(), BusinessdayCalendarInterface.DateRollConvention.FOLLOWING, string2);
        this.daycountScaling = 1.0;
        this.periodOffset = 0.0;
    }

    public ForwardCurveFromDiscountCurve(String string, Calendar calendar, String string2) {
        super("ForwardCurveFromDiscountCurve(" + string + "," + string2 + ")", calendar, string2, new BusinessdayCalendarExcludingWeekends(), BusinessdayCalendarInterface.DateRollConvention.FOLLOWING, string);
        this.daycountScaling = 1.0;
        this.periodOffset = 0.0;
    }

    @Override
    public double getForward(AnalyticModelInterface analyticModelInterface, double d) {
        double d2 = this.getPaymentOffset(d + this.periodOffset);
        double d3 = d2 * this.daycountScaling;
        return (analyticModelInterface.getDiscountCurve(this.discountCurveName).getDiscountFactor(analyticModelInterface, d + this.periodOffset) / analyticModelInterface.getDiscountCurve(this.discountCurveName).getDiscountFactor(analyticModelInterface, d + d2 + this.periodOffset) - 1.0) / d3;
    }

    @Override
    public double getForward(AnalyticModelInterface analyticModelInterface, double d, double d2) {
        double d3 = this.getPaymentOffset(d + this.periodOffset);
        if (Double.isNaN(d3)) {
            if (d2 <= 0.0) {
                throw new IllegalArgumentException("Requesting forward for period of length " + d2 + ".");
            }
            d3 = d2;
        }
        double d4 = d3 * this.daycountScaling;
        return (analyticModelInterface.getDiscountCurve(this.discountCurveName).getDiscountFactor(analyticModelInterface, d + this.periodOffset) / analyticModelInterface.getDiscountCurve(this.discountCurveName).getDiscountFactor(analyticModelInterface, d + d3 + this.periodOffset) - 1.0) / d4;
    }

    @Override
    public double getValue(double d) {
        return this.getValue(null, d);
    }

    @Override
    public double getValue(AnalyticModelInterface analyticModelInterface, double d) {
        return this.getForward(analyticModelInterface, d);
    }

    @Override
    public double[] getParameter() {
        return null;
    }
}

