/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractForwardCurve;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingWeekends;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;

public class ForwardCurve
extends AbstractForwardCurve
implements Serializable {
    private static final long serialVersionUID = -4126228588123963885L;
    private InterpolationEntityForward interpolationEntityForward = InterpolationEntityForward.FORWARD;

    public ForwardCurve(String string, Calendar calendar, String string2, BusinessdayCalendarInterface businessdayCalendarInterface, BusinessdayCalendarInterface.DateRollConvention dateRollConvention, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity, InterpolationEntityForward interpolationEntityForward, String string3) {
        super(string, calendar, string2, businessdayCalendarInterface, dateRollConvention, interpolationMethod, extrapolationMethod, interpolationEntity, string3);
        this.interpolationEntityForward = interpolationEntityForward;
        if (interpolationEntityForward == InterpolationEntityForward.DISCOUNTFACTOR) {
            super.addPoint(0.0, 1.0, false);
        }
    }

    public ForwardCurve(String string, Calendar calendar, String string2, InterpolationEntityForward interpolationEntityForward, String string3) {
        super(string, calendar, string2, new BusinessdayCalendarExcludingWeekends(), BusinessdayCalendarInterface.DateRollConvention.FOLLOWING, string3);
        this.interpolationEntityForward = interpolationEntityForward;
        if (interpolationEntityForward == InterpolationEntityForward.DISCOUNTFACTOR) {
            super.addPoint(0.0, 1.0, false);
        }
    }

    public ForwardCurve(String string, Calendar calendar, String string2, String string3) {
        this(string, calendar, string2, InterpolationEntityForward.FORWARD, string3);
    }

    public ForwardCurve(String string, double d, InterpolationEntityForward interpolationEntityForward, String string2) {
        super(string, null, d, string2);
        this.interpolationEntityForward = interpolationEntityForward;
    }

    public static ForwardCurve createForwardCurveFromForwards(String string, Calendar calendar, String string2, BusinessdayCalendarInterface businessdayCalendarInterface, BusinessdayCalendarInterface.DateRollConvention dateRollConvention, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity, InterpolationEntityForward interpolationEntityForward, String string3, AnalyticModelInterface analyticModelInterface, double[] dArray, double[] dArray2) {
        ForwardCurve forwardCurve = new ForwardCurve(string, calendar, string2, businessdayCalendarInterface, dateRollConvention, interpolationMethod, extrapolationMethod, interpolationEntity, interpolationEntityForward, string3);
        for (int i = 0; i < dArray.length; ++i) {
            forwardCurve.addForward(analyticModelInterface, dArray[i], dArray2[i], false);
        }
        return forwardCurve;
    }

    public static ForwardCurve createForwardCurveFromForwards(String string, Date date, String string2, BusinessdayCalendarInterface businessdayCalendarInterface, BusinessdayCalendarInterface.DateRollConvention dateRollConvention, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity, InterpolationEntityForward interpolationEntityForward, String string3, AnalyticModelInterface analyticModelInterface, double[] dArray, double[] dArray2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return ForwardCurve.createForwardCurveFromForwards(string, gregorianCalendar, string2, businessdayCalendarInterface, dateRollConvention, interpolationMethod, extrapolationMethod, interpolationEntity, interpolationEntityForward, string3, analyticModelInterface, dArray, dArray2);
    }

    public static ForwardCurve createForwardCurveFromForwards(String string, Date date, String string2, String string3, String string4, AnalyticModelInterface analyticModelInterface, double[] dArray, double[] dArray2) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return ForwardCurve.createForwardCurveFromForwards(string, calendar, string2, InterpolationEntityForward.valueOf(string3), string4, analyticModelInterface, dArray, dArray2);
    }

    public static ForwardCurve createForwardCurveFromForwards(String string, Calendar calendar, String string2, InterpolationEntityForward interpolationEntityForward, String string3, AnalyticModelInterface analyticModelInterface, double[] dArray, double[] dArray2) {
        ForwardCurve forwardCurve = new ForwardCurve(string, calendar, string2, interpolationEntityForward, string3);
        for (int i = 0; i < dArray.length; ++i) {
            forwardCurve.addForward(analyticModelInterface, dArray[i], dArray2[i], false);
        }
        return forwardCurve;
    }

    public static ForwardCurve createForwardCurveFromForwards(String string, double[] dArray, double[] dArray2, double d) {
        ForwardCurve forwardCurve = new ForwardCurve(string, d, InterpolationEntityForward.FORWARD, null);
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            boolean bl = d2 > 0.0;
            forwardCurve.addForward(null, d2, dArray2[i], bl);
        }
        return forwardCurve;
    }

    public static ForwardCurve createForwardCurveFromDiscountFactors(String string, double[] dArray, double[] dArray2, double d) {
        ForwardCurve forwardCurve = new ForwardCurve(string, d, InterpolationEntityForward.FORWARD, null);
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Vector of times must not be empty.");
        }
        if (dArray[0] > 0.0) {
            double d2 = (1.0 / dArray2[0] - 1.0) / (dArray[0] - 0.0);
            forwardCurve.addForward(null, 0.0, d2, true);
        }
        for (int i = 0; i < dArray.length - 1; ++i) {
            double d3 = (dArray2[i] / dArray2[i + 1] - 1.0) / (dArray[i + 1] - dArray[i]);
            double d4 = dArray[i];
            boolean bl = d4 > 0.0;
            forwardCurve.addForward(null, d4, d3, bl);
        }
        return forwardCurve;
    }

    public static ForwardCurve createForwardCurveFromForwards(String string, double[] dArray, double[] dArray2, AnalyticModelInterface analyticModelInterface, String string2, double d) {
        ForwardCurve forwardCurve = new ForwardCurve(string, d, InterpolationEntityForward.FORWARD, string2);
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            boolean bl = d2 > 0.0;
            forwardCurve.addForward(analyticModelInterface, d2, dArray2[i], bl);
        }
        return forwardCurve;
    }

    @Override
    public double getForward(AnalyticModelInterface analyticModelInterface, double d) {
        return this.getForward(analyticModelInterface, d, this.getPaymentOffset(d));
    }

    @Override
    public double getForward(AnalyticModelInterface analyticModelInterface, double d, double d2) {
        if (d2 != this.getPaymentOffset(d)) {
            // empty if block
        }
        d2 = this.getPaymentOffset(d);
        double d3 = this.getValue(analyticModelInterface, d);
        switch (this.interpolationEntityForward) {
            default: {
                return d3;
            }
            case FORWARD_TIMES_DISCOUNTFACTOR: {
                return d3 / analyticModelInterface.getDiscountCurve(this.discountCurveName).getValue(analyticModelInterface, d + d2);
            }
            case ZERO: {
                double d4 = this.getValue(analyticModelInterface, d + d2);
                return (Math.exp(d4 * (d + d2) - d3 * d) - 1.0) / d2;
            }
            case DISCOUNTFACTOR: 
        }
        double d5 = this.getValue(analyticModelInterface, d + d2);
        return (d3 / d5 - 1.0) / d2;
    }

    private void addForward(AnalyticModelInterface analyticModelInterface, double d, double d2, boolean bl) {
        double d3;
        double d4;
        switch (this.interpolationEntityForward) {
            default: {
                d4 = d;
                d3 = d2;
                break;
            }
            case FORWARD_TIMES_DISCOUNTFACTOR: {
                d4 = d;
                d3 = d2 * analyticModelInterface.getDiscountCurve(this.discountCurveName).getValue(analyticModelInterface, d + this.getPaymentOffset(d));
                break;
            }
            case ZERO: {
                double d5 = this.getPaymentOffset(d);
                d4 = d + d5;
                d3 = Math.log(1.0 + d2 * d5) / d5;
                break;
            }
            case DISCOUNTFACTOR: {
                double d6 = this.getPaymentOffset(d);
                d4 = d + d6;
                d3 = this.getValue(d) / (1.0 + d2 * d6);
            }
        }
        super.addPoint(d4, d3, bl);
    }

    @Override
    protected void addPoint(double d, double d2, boolean bl) {
        if (this.interpolationEntityForward == InterpolationEntityForward.DISCOUNTFACTOR) {
            d += this.getPaymentOffset(d);
        }
        super.addPoint(d, d2, bl);
    }

    public InterpolationEntityForward getInterpolationEntityForward() {
        return this.interpolationEntityForward;
    }

    @Override
    public String toString() {
        return "ForwardCurve [interpolationEntityForward=" + (Object)((Object)this.interpolationEntityForward) + ", toString()=" + super.toString() + "]";
    }

    public static enum InterpolationEntityForward {
        FORWARD,
        FORWARD_TIMES_DISCOUNTFACTOR,
        ZERO,
        DISCOUNTFACTOR;

    }
}

