/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.util.Calendar;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;

public class DiscountCurveFromProductOfCurves
extends AbstractCurve
implements Serializable,
DiscountCurveInterface {
    private static final long serialVersionUID = 8850409340966149755L;
    private DiscountCurveInterface[] curves;

    public DiscountCurveFromProductOfCurves(String string, Calendar calendar, DiscountCurveInterface ... discountCurveInterfaceArray) {
        super(string, calendar);
        this.curves = discountCurveInterfaceArray;
    }

    @Override
    public double getDiscountFactor(double d) {
        return this.getDiscountFactor(null, d);
    }

    @Override
    public double getDiscountFactor(AnalyticModelInterface analyticModelInterface, double d) {
        double d2 = 1.0;
        for (DiscountCurveInterface discountCurveInterface : this.curves) {
            d2 *= discountCurveInterface.getDiscountFactor(analyticModelInterface, d);
        }
        return d2;
    }

    @Override
    public double getValue(AnalyticModelInterface analyticModelInterface, double d) {
        return this.getDiscountFactor(analyticModelInterface, d);
    }

    @Override
    public double[] getParameter() {
        return null;
    }

    @Override
    public void setParameter(double[] dArray) {
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        return null;
    }
}

