/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;
import net.finmath.time.daycount.DayCountConvention_ACT_365;

public abstract class AbstractForwardCurve
extends Curve
implements ForwardCurveInterface {
    private static final long serialVersionUID = 3735595267579329042L;
    protected final String discountCurveName;
    private final Map<Double, Double> paymentOffsets = new ConcurrentHashMap<Double, Double>();
    protected final String paymentOffsetCode;
    protected final BusinessdayCalendarInterface paymentBusinessdayCalendar;
    protected final BusinessdayCalendarInterface.DateRollConvention paymentDateRollConvention;
    private final double paymentOffset;

    public AbstractForwardCurve(String string, Calendar calendar, String string2, BusinessdayCalendarInterface businessdayCalendarInterface, BusinessdayCalendarInterface.DateRollConvention dateRollConvention, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity, String string3) {
        super(string, calendar, interpolationMethod, extrapolationMethod, interpolationEntity);
        this.paymentOffsetCode = string2;
        this.paymentBusinessdayCalendar = businessdayCalendarInterface;
        this.paymentDateRollConvention = dateRollConvention;
        this.paymentOffset = Double.NaN;
        this.discountCurveName = string3;
    }

    public AbstractForwardCurve(String string, Calendar calendar, String string2, BusinessdayCalendarInterface businessdayCalendarInterface, BusinessdayCalendarInterface.DateRollConvention dateRollConvention, String string3) {
        super(string, calendar, Curve.InterpolationMethod.LINEAR, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.VALUE);
        this.paymentOffsetCode = string2;
        this.paymentBusinessdayCalendar = businessdayCalendarInterface;
        this.paymentDateRollConvention = dateRollConvention;
        this.paymentOffset = Double.NaN;
        this.discountCurveName = string3;
    }

    public AbstractForwardCurve(String string, Calendar calendar, double d, String string2) {
        super(string, calendar, Curve.InterpolationMethod.LINEAR, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.VALUE);
        this.paymentOffset = d;
        this.discountCurveName = string2;
        this.paymentOffsetCode = null;
        this.paymentBusinessdayCalendar = null;
        this.paymentDateRollConvention = null;
    }

    @Override
    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    @Override
    public double getPaymentOffset(double d) {
        if (this.paymentOffsetCode == null) {
            return this.paymentOffset;
        }
        if (this.paymentOffsets.containsKey(d)) {
            return this.paymentOffsets.get(d);
        }
        Calendar calendar = (Calendar)this.getReferenceDate().clone();
        calendar.add(6, (int)Math.round(d * 365.0));
        calendar = this.paymentBusinessdayCalendar.getAdjustedDate(calendar, this.paymentOffsetCode, this.paymentDateRollConvention);
        double d2 = new DayCountConvention_ACT_365().getDaycountFraction(this.getReferenceDate(), calendar);
        this.paymentOffsets.put(d, d2 - d);
        return d2 - d;
    }

    public double[] getForwards(AnalyticModelInterface analyticModelInterface, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = this.getForward(analyticModelInterface, dArray[i]);
        }
        return dArray2;
    }
}

