/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.finmath.marketdata.calibration.ParameterObjectInterface;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurface;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;

public class AnalyticModel
implements AnalyticModelInterface,
Cloneable {
    private final Map<String, CurveInterface> curvesMap = new HashMap<String, CurveInterface>();
    private final Map<String, VolatilitySurfaceInterface> volatilitySufaceMap = new HashMap<String, VolatilitySurfaceInterface>();

    public AnalyticModel() {
    }

    public AnalyticModel(CurveInterface[] curveInterfaceArray) {
        for (CurveInterface curveInterface : curveInterfaceArray) {
            this.curvesMap.put(curveInterface.getName(), curveInterface);
        }
    }

    public AnalyticModel(Collection<CurveInterface> collection) {
        for (CurveInterface curveInterface : collection) {
            this.curvesMap.put(curveInterface.getName(), curveInterface);
        }
    }

    @Override
    public CurveInterface getCurve(String string) {
        return this.curvesMap.get(string);
    }

    @Override
    public AnalyticModelInterface addCurve(String string, CurveInterface curveInterface) {
        AnalyticModel analyticModel = this.clone();
        analyticModel.curvesMap.put(string, curveInterface);
        return analyticModel;
    }

    public AnalyticModelInterface addCurve(CurveInterface curveInterface) {
        AnalyticModel analyticModel = this.clone();
        analyticModel.curvesMap.put(curveInterface.getName(), curveInterface);
        return analyticModel;
    }

    @Override
    public AnalyticModelInterface addCurves(CurveInterface ... curveInterfaceArray) {
        AnalyticModel analyticModel = this.clone();
        for (CurveInterface curveInterface : curveInterfaceArray) {
            analyticModel.curvesMap.put(curveInterface.getName(), curveInterface);
        }
        return analyticModel;
    }

    @Override
    public AnalyticModelInterface addCurves(Set<CurveInterface> set) {
        AnalyticModel analyticModel = this.clone();
        for (CurveInterface curveInterface : set) {
            analyticModel.curvesMap.put(curveInterface.getName(), curveInterface);
        }
        return analyticModel;
    }

    @Override
    @Deprecated
    public void setCurve(CurveInterface curveInterface) {
        this.curvesMap.put(curveInterface.getName(), curveInterface);
    }

    @Deprecated
    public void setCurves(CurveInterface[] curveInterfaceArray) {
        for (CurveInterface curveInterface : curveInterfaceArray) {
            this.setCurve(curveInterface);
        }
    }

    @Override
    public DiscountCurveInterface getDiscountCurve(String string) {
        DiscountCurveInterface discountCurveInterface = null;
        CurveInterface curveInterface = this.getCurve(string);
        if (DiscountCurveInterface.class.isInstance(curveInterface)) {
            discountCurveInterface = (DiscountCurveInterface)curveInterface;
        } else if (ForwardCurveInterface.class.isInstance(curveInterface)) {
            ForwardCurveInterface forwardCurveInterface = (ForwardCurveInterface)curveInterface;
            discountCurveInterface = new DiscountCurveFromForwardCurve(forwardCurveInterface.getName());
        }
        return discountCurveInterface;
    }

    @Override
    public ForwardCurveInterface getForwardCurve(String string) {
        ForwardCurveInterface forwardCurveInterface = null;
        CurveInterface curveInterface = this.getCurve(string);
        if (ForwardCurveInterface.class.isInstance(curveInterface)) {
            forwardCurveInterface = (ForwardCurveInterface)curveInterface;
        }
        return forwardCurveInterface;
    }

    @Override
    public VolatilitySurfaceInterface getVolatilitySurface(String string) {
        return this.volatilitySufaceMap.get(string);
    }

    public AnalyticModelInterface addVolatilitySurface(VolatilitySurfaceInterface volatilitySurfaceInterface) {
        AnalyticModel analyticModel = this.clone();
        analyticModel.volatilitySufaceMap.put(volatilitySurfaceInterface.getName(), volatilitySurfaceInterface);
        return analyticModel;
    }

    @Override
    public AnalyticModelInterface addVolatilitySurfaces(VolatilitySurfaceInterface ... volatilitySurfaceInterfaceArray) {
        AnalyticModel analyticModel = this.clone();
        for (VolatilitySurfaceInterface volatilitySurfaceInterface : volatilitySurfaceInterfaceArray) {
            analyticModel.volatilitySufaceMap.put(volatilitySurfaceInterface.getName(), volatilitySurfaceInterface);
        }
        return analyticModel;
    }

    @Override
    public AnalyticModelInterface addVolatilitySurfaces(Set<AbstractVolatilitySurface> set) {
        AnalyticModel analyticModel = this.clone();
        for (VolatilitySurfaceInterface volatilitySurfaceInterface : set) {
            analyticModel.volatilitySufaceMap.put(volatilitySurfaceInterface.getName(), volatilitySurfaceInterface);
        }
        return analyticModel;
    }

    @Override
    @Deprecated
    public void setVolatilitySurface(VolatilitySurfaceInterface volatilitySurfaceInterface) {
        this.volatilitySufaceMap.put(volatilitySurfaceInterface.getName(), volatilitySurfaceInterface);
    }

    private void set(Object object) {
        if (object instanceof CurveInterface) {
            this.setCurve((CurveInterface)object);
        } else if (object instanceof VolatilitySurfaceInterface) {
            this.setVolatilitySurface((VolatilitySurfaceInterface)object);
        } else {
            throw new IllegalArgumentException("Provided object is not of supported type.");
        }
    }

    @Override
    public AnalyticModel clone() {
        AnalyticModel analyticModel = new AnalyticModel();
        analyticModel.curvesMap.putAll(this.curvesMap);
        analyticModel.volatilitySufaceMap.putAll(this.volatilitySufaceMap);
        return analyticModel;
    }

    @Override
    public AnalyticModelInterface getCloneForParameter(Map<ParameterObjectInterface, double[]> map) throws CloneNotSupportedException {
        AnalyticModel analyticModel = this.clone();
        if (map != null) {
            for (Map.Entry<ParameterObjectInterface, double[]> entry : map.entrySet()) {
                ParameterObjectInterface parameterObjectInterface = entry.getKey().getCloneForParameter(entry.getValue());
                analyticModel.set(parameterObjectInterface);
            }
        }
        return analyticModel;
    }
}

