/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.calibration;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.finmath.marketdata.calibration.ParameterAggregation;
import net.finmath.marketdata.calibration.ParameterObjectInterface;
import net.finmath.marketdata.calibration.ParameterTransformation;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.optimizer.OptimizerFactoryInterface;
import net.finmath.optimizer.OptimizerFactoryLevenbergMarquardt;
import net.finmath.optimizer.OptimizerInterface;
import net.finmath.optimizer.SolverException;

public class Solver {
    private final AnalyticModelInterface model;
    private final List<AnalyticProductInterface> calibrationProducts;
    private final List<Double> calibrationTargetValues;
    private final double calibrationAccuracy;
    private final ParameterTransformation parameterTransformation;
    private OptimizerFactoryInterface optimizerFactory;
    private final double evaluationTime;
    private final int maxIterations = 1000;
    private int iterations = 0;
    private double accuracy = Double.POSITIVE_INFINITY;

    public Solver(AnalyticModelInterface analyticModelInterface, Vector<AnalyticProductInterface> vector, List<Double> list, ParameterTransformation parameterTransformation, double d, OptimizerFactoryInterface optimizerFactoryInterface) {
        this.model = analyticModelInterface;
        this.calibrationProducts = vector;
        this.calibrationTargetValues = list;
        this.parameterTransformation = parameterTransformation;
        this.evaluationTime = d;
        this.optimizerFactory = optimizerFactoryInterface;
        this.calibrationAccuracy = 0.0;
    }

    public Solver(AnalyticModelInterface analyticModelInterface, Vector<AnalyticProductInterface> vector, List<Double> list, ParameterTransformation parameterTransformation, double d, double d2) {
        this.model = analyticModelInterface;
        this.calibrationProducts = vector;
        this.calibrationTargetValues = list;
        this.parameterTransformation = parameterTransformation;
        this.evaluationTime = d;
        this.calibrationAccuracy = d2;
        this.optimizerFactory = null;
    }

    public Solver(AnalyticModelInterface analyticModelInterface, Vector<AnalyticProductInterface> vector, List<Double> list, double d, double d2) {
        this(analyticModelInterface, vector, list, null, d, d2);
    }

    public Solver(AnalyticModelInterface analyticModelInterface, Vector<AnalyticProductInterface> vector, double d, double d2) {
        this(analyticModelInterface, vector, null, null, d, d2);
    }

    public Solver(AnalyticModelInterface analyticModelInterface, Vector<AnalyticProductInterface> vector) {
        this(analyticModelInterface, vector, 0.0, 0.0);
    }

    public AnalyticModelInterface getCalibratedModel(Set<ParameterObjectInterface> set) throws SolverException {
        final ParameterAggregation<ParameterObjectInterface> parameterAggregation = new ParameterAggregation<ParameterObjectInterface>(set);
        double[] dArray = this.parameterTransformation != null ? this.parameterTransformation.getSolverParameter(parameterAggregation.getParameter()) : parameterAggregation.getParameter();
        double[] dArray2 = new double[this.calibrationProducts.size()];
        double[] dArray3 = new double[this.calibrationProducts.size()];
        double[] dArray4 = new double[dArray.length];
        double[] dArray5 = new double[dArray.length];
        Arrays.fill(dArray2, 0.0);
        Arrays.fill(dArray3, 1.0);
        Arrays.fill(dArray4, Double.NEGATIVE_INFINITY);
        Arrays.fill(dArray5, Double.POSITIVE_INFINITY);
        OptimizerInterface.ObjectiveFunction objectiveFunction = new OptimizerInterface.ObjectiveFunction(){

            @Override
            public void setValues(double[] dArray, double[] dArray2) throws SolverException {
                try {
                    int n;
                    if (Solver.this.parameterTransformation != null) {
                        dArray = Solver.this.parameterTransformation.getParameter(dArray);
                    }
                    Map<ParameterObjectInterface, double[]> map = parameterAggregation.getObjectsToModifyForParameter(dArray);
                    AnalyticModelInterface analyticModelInterface = Solver.this.model.getCloneForParameter(map);
                    for (n = 0; n < Solver.this.calibrationProducts.size(); ++n) {
                        dArray2[n] = ((AnalyticProductInterface)Solver.this.calibrationProducts.get(n)).getValue(Solver.this.evaluationTime, analyticModelInterface);
                    }
                    if (Solver.this.calibrationTargetValues != null) {
                        for (n = 0; n < Solver.this.calibrationTargetValues.size(); ++n) {
                            int n2 = n;
                            dArray2[n2] = dArray2[n2] - (Double)Solver.this.calibrationTargetValues.get(n);
                        }
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new SolverException(cloneNotSupportedException);
                }
            }
        };
        if (this.optimizerFactory == null) {
            int n = Math.min(2 * Math.max(Runtime.getRuntime().availableProcessors(), 1), dArray.length);
            this.optimizerFactory = new OptimizerFactoryLevenbergMarquardt(1000, this.calibrationAccuracy, n);
        }
        OptimizerInterface optimizerInterface = this.optimizerFactory.getOptimizer(objectiveFunction, dArray, dArray4, dArray5, dArray2);
        optimizerInterface.run();
        this.iterations = optimizerInterface.getIterations();
        double[] dArray6 = optimizerInterface.getBestFitParameters();
        if (this.parameterTransformation != null) {
            dArray6 = this.parameterTransformation.getParameter(dArray6);
        }
        AnalyticModelInterface analyticModelInterface = null;
        try {
            Map<ParameterObjectInterface, double[]> map = parameterAggregation.getObjectsToModifyForParameter(dArray6);
            analyticModelInterface = this.model.getCloneForParameter(map);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SolverException(cloneNotSupportedException);
        }
        this.accuracy = 0.0;
        for (int i = 0; i < this.calibrationProducts.size(); ++i) {
            double d = this.calibrationProducts.get(i).getValue(this.evaluationTime, analyticModelInterface);
            if (this.calibrationTargetValues != null) {
                d -= this.calibrationTargetValues.get(i).doubleValue();
            }
            this.accuracy += d * d;
        }
        this.accuracy = Math.sqrt(this.accuracy / (double)this.calibrationProducts.size());
        return analyticModelInterface;
    }

    public int getIterations() {
        return this.iterations;
    }

    public double getAccuracy() {
        return this.accuracy;
    }
}

