/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.calibration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.finmath.marketdata.calibration.ParameterObjectInterface;
import net.finmath.marketdata.model.curves.CurveInterface;

public class ParameterAggregation<E extends ParameterObjectInterface>
implements ParameterObjectInterface {
    private final Set<ParameterObjectInterface> parameters;

    public ParameterAggregation() {
        this.parameters = new LinkedHashSet<ParameterObjectInterface>();
    }

    public ParameterAggregation(Set<E> set) {
        this.parameters = new LinkedHashSet<ParameterObjectInterface>(set);
    }

    public ParameterAggregation(E[] EArray) {
        this.parameters = new LinkedHashSet<ParameterObjectInterface>(Arrays.asList(EArray));
    }

    public void add(E e) {
        this.parameters.add((ParameterObjectInterface)e);
    }

    public void remove(E e) {
        this.parameters.remove(e);
    }

    @Override
    public double[] getParameter() {
        int n = 0;
        for (ParameterObjectInterface parameterObjectInterface : this.parameters) {
            if (parameterObjectInterface.getParameter() == null) continue;
            n += parameterObjectInterface.getParameter().length;
        }
        Object object = new double[n];
        int n2 = 0;
        for (ParameterObjectInterface parameterObjectInterface : this.parameters) {
            double[] dArray = parameterObjectInterface.getParameter();
            if (dArray == null) continue;
            System.arraycopy(dArray, 0, object, n2, dArray.length);
            n2 += dArray.length;
        }
        return object;
    }

    @Override
    public void setParameter(double[] dArray) {
        int n = 0;
        for (ParameterObjectInterface parameterObjectInterface : this.parameters) {
            double[] dArray2 = parameterObjectInterface.getParameter();
            if (dArray2 == null) continue;
            System.arraycopy(dArray, n, dArray2, 0, dArray2.length);
            n += dArray2.length;
            parameterObjectInterface.setParameter(dArray2);
        }
    }

    public Map<E, double[]> getObjectsToModifyForParameter(double[] dArray) {
        HashMap<ParameterObjectInterface, double[]> hashMap = new HashMap<ParameterObjectInterface, double[]>();
        int n = 0;
        for (ParameterObjectInterface parameterObjectInterface : this.parameters) {
            double[] dArray2 = (double[])parameterObjectInterface.getParameter().clone();
            if (dArray2 == null) continue;
            System.arraycopy(dArray, n, dArray2, 0, dArray2.length);
            n += dArray2.length;
            hashMap.put(parameterObjectInterface, dArray2);
        }
        return hashMap;
    }

    @Override
    public CurveInterface getCloneForParameter(double[] dArray) throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Method getCloneForParameter not supported on an aggregate.");
    }
}

