/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.calibration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import net.finmath.marketdata.calibration.ParameterObjectInterface;
import net.finmath.marketdata.calibration.Solver;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.optimizer.SolverException;
import net.finmath.time.RegularSchedule;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.TimeDiscretization;

public class CalibratedCurves {
    private AnalyticModelInterface model = new AnalyticModel();
    private Set<ParameterObjectInterface> objectsToCalibrate = new LinkedHashSet<ParameterObjectInterface>();
    private Vector<AnalyticProductInterface> calibrationProducts = new Vector();
    private double evaluationTime = 0.0;
    private int lastNumberOfInterations;
    private double lastAccuracy;

    public CalibratedCurves(CalibrationSpec[] calibrationSpecArray, AnalyticModel analyticModel, double d, double d2) throws SolverException, CloneNotSupportedException {
        if (analyticModel != null) {
            this.model = analyticModel.getCloneForParameter(null);
        }
        this.evaluationTime = d;
        for (CalibrationSpec calibrationSpec : calibrationSpecArray) {
            this.add(calibrationSpec);
        }
        this.lastNumberOfInterations = this.calibrate(d2);
    }

    public CalibratedCurves(CalibrationSpec[] calibrationSpecArray, AnalyticModel analyticModel, double d) throws SolverException, CloneNotSupportedException {
        this(calibrationSpecArray, analyticModel, 0.0, d);
    }

    public CalibratedCurves(CalibrationSpec[] calibrationSpecArray, AnalyticModel analyticModel) throws SolverException, CloneNotSupportedException {
        this(calibrationSpecArray, analyticModel, 0.0);
    }

    public CalibratedCurves(Collection<CalibrationSpec> collection) throws SolverException, CloneNotSupportedException {
        this(collection.toArray(new CalibrationSpec[collection.size()]), null);
    }

    public CalibratedCurves(CalibrationSpec[] calibrationSpecArray) throws SolverException, CloneNotSupportedException {
        this(calibrationSpecArray, null, 0.0);
    }

    public AnalyticProductInterface getCalibrationProductForSpec(CalibrationSpec calibrationSpec) {
        this.createDiscountCurve(calibrationSpec.discountCurveReceiverName);
        this.createDiscountCurve(calibrationSpec.discountCurvePayerName);
        String string = this.createForwardCurve(calibrationSpec.swapTenorDefinitionReceiver, calibrationSpec.forwardCurveReceiverName);
        String string2 = this.createForwardCurve(calibrationSpec.swapTenorDefinitionPayer, calibrationSpec.forwardCurvePayerName);
        ScheduleInterface scheduleInterface = calibrationSpec.swapTenorDefinitionReceiver;
        ScheduleInterface scheduleInterface2 = calibrationSpec.swapTenorDefinitionPayer;
        AbstractAnalyticProduct abstractAnalyticProduct = null;
        if (calibrationSpec.type.toLowerCase().equals("swap")) {
            abstractAnalyticProduct = new Swap(scheduleInterface, string, calibrationSpec.spreadReceiver, calibrationSpec.discountCurveReceiverName, scheduleInterface2, string2, calibrationSpec.spreadPayer, calibrationSpec.discountCurvePayerName);
        } else if (calibrationSpec.type.toLowerCase().equals("swapleg")) {
            abstractAnalyticProduct = new SwapLeg(scheduleInterface, string, calibrationSpec.spreadReceiver, calibrationSpec.discountCurveReceiverName, true);
        } else {
            throw new RuntimeException("Product of type " + calibrationSpec.type + " unknown.");
        }
        return abstractAnalyticProduct;
    }

    public AnalyticModelInterface getModel() {
        return this.model;
    }

    public CurveInterface getCurve(String string) {
        return this.model.getCurve(string);
    }

    public int getLastNumberOfInterations() {
        return this.lastNumberOfInterations;
    }

    public double getLastAccuracy() {
        return this.lastAccuracy;
    }

    private int calibrate(double d) throws SolverException {
        Solver solver = new Solver(this.model, this.calibrationProducts, this.evaluationTime, d);
        this.model = solver.getCalibratedModel(this.objectsToCalibrate);
        this.lastAccuracy = solver.getAccuracy();
        return solver.getIterations();
    }

    private String add(CalibrationSpec calibrationSpec) throws CloneNotSupportedException {
        this.calibrationProducts.add(this.getCalibrationProductForSpec(calibrationSpec));
        CurveInterface curveInterface = this.model.getCurve(calibrationSpec.calibrationCurveName);
        this.objectsToCalibrate.remove(curveInterface);
        CurveInterface curveInterface2 = null;
        if (DiscountCurveInterface.class.isInstance(curveInterface)) {
            double d = calibrationSpec.swapTenorDefinitionReceiver.getPayment(calibrationSpec.swapTenorDefinitionReceiver.getNumberOfPeriods() - 1);
            curveInterface2 = curveInterface.getCloneBuilder().addPoint(calibrationSpec.calibrationTime, 1.0, true).build();
        } else {
            curveInterface2 = ForwardCurveInterface.class.isInstance(curveInterface) ? curveInterface.getCloneBuilder().addPoint(calibrationSpec.calibrationTime, 0.1, true).build() : curveInterface.getCloneBuilder().addPoint(calibrationSpec.calibrationTime, 1.0, true).build();
        }
        this.model.setCurve(curveInterface2);
        this.objectsToCalibrate.add(curveInterface2);
        return calibrationSpec.type;
    }

    private DiscountCurveInterface createDiscountCurve(String string) {
        DiscountCurveInterface discountCurveInterface = this.model.getDiscountCurve(string);
        if (discountCurveInterface == null) {
            discountCurveInterface = DiscountCurve.createDiscountCurveFromDiscountFactors(string, new double[]{0.0}, new double[]{1.0});
            this.model.setCurve(discountCurveInterface);
        }
        return discountCurveInterface;
    }

    private String createForwardCurve(ScheduleInterface scheduleInterface, String string) {
        String string2 = null;
        if (string.contains("_12M") || string.contains("-12M") || string.contains(" 12M")) {
            string2 = "12M";
        }
        if (string.contains("_1M") || string.contains("-1M") || string.contains(" 1M")) {
            string2 = "1M";
        }
        if (string.contains("_6M") || string.contains("-6M") || string.contains(" 6M")) {
            string2 = "6M";
        }
        if (string.contains("_3M") || string.contains("-3M") || string.contains(" 3M")) {
            string2 = "3M";
        }
        if (string == null || string.isEmpty()) {
            return null;
        }
        CurveInterface curveInterface = this.model.getCurve(string);
        CurveInterface curveInterface2 = null;
        if (curveInterface == null) {
            boolean bl = true;
            if (bl) {
                curveInterface = new ForwardCurve(string, scheduleInterface.getReferenceDate(), string2, ForwardCurve.InterpolationEntityForward.FORWARD, null);
            } else {
                curveInterface = DiscountCurve.createDiscountCurveFromDiscountFactors(string, new double[]{0.0}, new double[]{1.0});
                this.model.setCurve(curveInterface);
            }
        }
        curveInterface2 = DiscountCurveInterface.class.isInstance(curveInterface) ? new ForwardCurveFromDiscountCurve(curveInterface.getName(), scheduleInterface.getReferenceDate(), string2) : curveInterface;
        this.model.setCurve(curveInterface2);
        return curveInterface2.getName();
    }

    public static class CalibrationSpec {
        private String type;
        private ScheduleInterface swapTenorDefinitionReceiver;
        private String forwardCurveReceiverName;
        private double spreadReceiver;
        private String discountCurveReceiverName;
        private ScheduleInterface swapTenorDefinitionPayer;
        private String forwardCurvePayerName;
        private double spreadPayer;
        private String discountCurvePayerName;
        private String calibrationCurveName;
        private double calibrationTime;

        public CalibrationSpec(String string, ScheduleInterface scheduleInterface, String string2, double d, String string3, ScheduleInterface scheduleInterface2, String string4, double d2, String string5, String string6, double d3) {
            this.type = string;
            this.swapTenorDefinitionReceiver = scheduleInterface;
            this.forwardCurveReceiverName = string2;
            this.spreadReceiver = d;
            this.discountCurveReceiverName = string3;
            this.swapTenorDefinitionPayer = scheduleInterface2;
            this.forwardCurvePayerName = string4;
            this.spreadPayer = d2;
            this.discountCurvePayerName = string5;
            this.calibrationCurveName = string6;
            this.calibrationTime = d3;
        }

        public CalibrationSpec(String string, double[] dArray, String string2, double d, String string3, double[] dArray2, String string4, double d2, String string5, String string6, double d3) {
            this.type = string;
            this.swapTenorDefinitionReceiver = new RegularSchedule(new TimeDiscretization(dArray[0], dArray[1], dArray[2], TimeDiscretization.ShortPeriodLocation.SHORT_PERIOD_AT_START));
            this.forwardCurveReceiverName = string2;
            this.spreadReceiver = d;
            this.discountCurveReceiverName = string3;
            this.swapTenorDefinitionPayer = new RegularSchedule(new TimeDiscretization(dArray2[0], dArray2[1], dArray2[2], TimeDiscretization.ShortPeriodLocation.SHORT_PERIOD_AT_START));
            this.forwardCurvePayerName = string4;
            this.spreadPayer = d2;
            this.discountCurvePayerName = string5;
            this.calibrationCurveName = string6;
            this.calibrationTime = d3;
        }

        public CalibrationSpec(String string, double[] dArray, String string2, double d, String string3, String string4, double d2) {
            this.type = string;
            this.swapTenorDefinitionReceiver = new RegularSchedule(new TimeDiscretization(dArray[0], dArray[1], dArray[2], TimeDiscretization.ShortPeriodLocation.SHORT_PERIOD_AT_START));
            this.forwardCurveReceiverName = string2;
            this.spreadReceiver = d;
            this.discountCurveReceiverName = string3;
            this.calibrationCurveName = string4;
            this.calibrationTime = d2;
        }

        public String toString() {
            return "CalibrationSpec [type=" + this.type + ", swapTenorDefinitionReceiver=" + this.swapTenorDefinitionReceiver + ", forwardCurveReceiverName=" + this.forwardCurveReceiverName + ", spreadReceiver=" + this.spreadReceiver + ", discountCurveReceiverName=" + this.discountCurveReceiverName + ", swapTenorDefinitionPayer=" + this.swapTenorDefinitionPayer + ", forwardCurvePayerName=" + this.forwardCurvePayerName + ", spreadPayer=" + this.spreadPayer + ", discountCurvePayerName=" + this.discountCurvePayerName + ", calibrationCurveName=" + this.calibrationCurveName + ", calibrationTime=" + this.calibrationTime + "]";
        }
    }
}

