/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.functions;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class LinearAlgebra {
    public static double[] solveLinearEquation(double[][] dArray, double[] dArray2) {
        Algebra algebra = new Algebra();
        double[] dArray3 = algebra.solve((DoubleMatrix2D)new DenseDoubleMatrix2D(dArray), algebra.transpose((DoubleMatrix2D)new DenseDoubleMatrix2D((double[][])new double[][]{dArray2}))).viewColumn(0).toArray();
        return dArray3;
    }

    public static double[][] invert(double[][] dArray) {
        Algebra algebra = new Algebra();
        double[][] dArray2 = algebra.inverse((DoubleMatrix2D)new DenseDoubleMatrix2D(dArray)).toArray();
        return dArray2;
    }

    public static double[] solveLinearEquationSymmetric(double[][] dArray, double[] dArray2) {
        boolean bl = true;
        if (bl) {
            DecompositionSolver decompositionSolver = new CholeskyDecomposition((RealMatrix)new Array2DRowRealMatrix(dArray, false)).getSolver();
            return decompositionSolver.solve((RealVector)new ArrayRealVector(dArray2)).toArray();
        }
        return LinearAlgebra.solveLinearEquation(dArray, dArray2);
    }

    public static double[] solveLinearEquationLeastSquare(double[][] dArray, double[] dArray2) {
        DecompositionSolver decompositionSolver = new SingularValueDecomposition((RealMatrix)new Array2DRowRealMatrix(dArray, false)).getSolver();
        return decompositionSolver.solve((RealVector)new ArrayRealVector(dArray2)).toArray();
    }

    public static double[][] getFactorMatrix(double[][] dArray, int n) {
        boolean bl = true;
        if (bl) {
            return LinearAlgebra.getFactorMatrixUsingCommonsMath(dArray, n);
        }
        return LinearAlgebra.getFactorMatrixUsingColt((DoubleMatrix2D)new DenseDoubleMatrix2D(dArray), n).toArray();
    }

    public static double[][] factorReduction(double[][] dArray, int n) {
        boolean bl = true;
        if (bl) {
            return LinearAlgebra.factorReductionUsingCommonsMath(dArray, n);
        }
        return LinearAlgebra.factorReductionUsingColt((DoubleMatrix2D)new DenseDoubleMatrix2D(dArray), n).toArray();
    }

    private static double[][] getFactorMatrixUsingCommonsMath(double[][] dArray, int n) {
        EigenDecomposition eigenDecomposition = new EigenDecomposition((RealMatrix)new Array2DRowRealMatrix(dArray, false));
        double[] dArray2 = eigenDecomposition.getRealEigenvalues();
        double[][] dArray3 = eigenDecomposition.getV().getData();
        class EigenValueIndex
        implements Comparable<EigenValueIndex> {
            private int index;
            Double value;

            public EigenValueIndex(int n, double d) {
                this.index = n;
                this.value = d;
            }

            @Override
            public int compareTo(EigenValueIndex eigenValueIndex) {
                return eigenValueIndex.value.compareTo(this.value);
            }
        }
        ArrayList<EigenValueIndex> arrayList = new ArrayList<EigenValueIndex>();
        for (int i = 0; i < dArray2.length; ++i) {
            arrayList.add(i, new EigenValueIndex(i, dArray2[i]));
        }
        Collections.sort(arrayList);
        double[][] dArray4 = new double[dArray2.length][n];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = ((EigenValueIndex)arrayList.get(i)).index;
            double d = dArray2[n3];
            double d2 = dArray3[0][n3] > 0.0 ? 1.0 : -1.0;
            double d3 = 0.0;
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                d3 += dArray3[n2][n3] * dArray3[n2][n3];
            }
            d = Math.max(d, 0.0);
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                dArray4[n2][i] = d2 * Math.sqrt(d / d3) * dArray3[n2][n3];
            }
        }
        return dArray4;
    }

    private static DoubleMatrix2D getFactorMatrixUsingColt(DoubleMatrix2D doubleMatrix2D, int n) {
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(doubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D2 = eigenvalueDecomposition.getV();
        DoubleMatrix1D doubleMatrix1D = eigenvalueDecomposition.getRealEigenvalues();
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(doubleMatrix1D.size(), 2);
        for (int i = 0; i < doubleMatrix1D.size(); ++i) {
            denseDoubleMatrix2D.set(i, 0, doubleMatrix1D.get(i));
            denseDoubleMatrix2D.set(i, 1, (double)i);
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(doubleMatrix2D2.rows(), n);
        for (int i = 0; i < n; ++i) {
            int n2;
            double d = denseDoubleMatrix2D.get(denseDoubleMatrix2D.rows() - 1 - i, 0);
            int n3 = (int)denseDoubleMatrix2D.get(denseDoubleMatrix2D.rows() - 1 - i, 1);
            double d2 = doubleMatrix2D2.get(0, n3) > 0.0 ? 1.0 : -1.0;
            double d3 = 0.0;
            for (n2 = 0; n2 < denseDoubleMatrix2D.rows(); ++n2) {
                d3 += doubleMatrix2D2.get(n2, n3) * doubleMatrix2D2.get(n2, n3);
            }
            d = Math.max(d, 0.0);
            for (n2 = 0; n2 < denseDoubleMatrix2D.rows(); ++n2) {
                denseDoubleMatrix2D2.set(n2, i, d2 * Math.sqrt(d / d3) * doubleMatrix2D2.get(n2, n3));
            }
        }
        return denseDoubleMatrix2D2;
    }

    public static double[][] factorReductionUsingCommonsMath(double[][] dArray, int n) {
        double[][] dArray2 = LinearAlgebra.getFactorMatrix(dArray, n);
        for (int i = 0; i < dArray.length; ++i) {
            int n2;
            double d = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += dArray2[i][n2] * dArray2[i][n2];
            }
            if (d != 0.0) {
                for (n2 = 0; n2 < n; ++n2) {
                    dArray2[i][n2] = dArray2[i][n2] / Math.sqrt(d);
                }
                continue;
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray2[i][n2] = 1.0;
            }
        }
        double[][] dArray3 = new Array2DRowRealMatrix(dArray2).multiply(new Array2DRowRealMatrix(dArray2).transpose()).getData();
        return LinearAlgebra.getFactorMatrix(dArray3, n);
    }

    public static DoubleMatrix2D factorReductionUsingColt(DoubleMatrix2D doubleMatrix2D, int n) {
        DoubleMatrix2D doubleMatrix2D2 = LinearAlgebra.getFactorMatrixUsingColt(doubleMatrix2D, n);
        for (int i = 0; i < doubleMatrix2D2.rows(); ++i) {
            int n2;
            double d = 0.0;
            for (n2 = 0; n2 < doubleMatrix2D2.columns(); ++n2) {
                d += doubleMatrix2D2.get(i, n2) * doubleMatrix2D2.get(i, n2);
            }
            if (d != 0.0) {
                for (n2 = 0; n2 < doubleMatrix2D2.columns(); ++n2) {
                    doubleMatrix2D2.set(i, n2, doubleMatrix2D2.get(i, n2) / Math.sqrt(d));
                }
                continue;
            }
            for (n2 = 0; n2 < doubleMatrix2D2.columns(); ++n2) {
                doubleMatrix2D2.set(i, n2, 1.0);
            }
        }
        Algebra algebra = new Algebra();
        DoubleMatrix2D doubleMatrix2D3 = algebra.mult(doubleMatrix2D2, algebra.transpose(doubleMatrix2D2));
        return LinearAlgebra.getFactorMatrixUsingColt(doubleMatrix2D3, n);
    }
}

