/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.rkcheck;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.spaceroots.rkcheck.EmbeddedCatalogResolver;
import org.spaceroots.rkcheck.RKCheckException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLFile
implements ErrorHandler {
    protected String uri;
    private DocumentBuilderFactory factory;
    private EmbeddedCatalogResolver resolver;

    public XMLFile() throws RKCheckException {
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setValidating(true);
            this.resolver = new EmbeddedCatalogResolver("/org/spaceroots/resources/catalog", this.factory.newDocumentBuilder());
        }
        catch (ParserConfigurationException pce) {
            throw new RKCheckException(pce);
        }
    }

    public void read(String uri) throws RKCheckException, IOException, FileNotFoundException {
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            builder.setEntityResolver(this.resolver);
            builder.setErrorHandler(this);
            Document document = builder.parse(uri);
            this.analyze(document, uri);
        }
        catch (NumberFormatException nfe) {
            throw new RKCheckException(nfe);
        }
        catch (ParserConfigurationException pce) {
            throw new RKCheckException(pce);
        }
        catch (SAXException se) {
            if (se.getException() != null && se.getException() instanceof RKCheckException) {
                throw (RKCheckException)se.getException();
            }
            throw new RKCheckException(se);
        }
    }

    public void write(Writer writer, String uri) throws RKCheckException, IOException {
        try {
            Document document = this.factory.newDocumentBuilder().newDocument();
            this.build(document, uri);
            this.indent(document, document.getDocumentElement(), "", "  ");
            document.getDocumentElement().normalize();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("doctype-public", this.getPublicId());
            t.setOutputProperty("doctype-system", this.getSystemId());
            t.transform(new DOMSource(document.getDocumentElement()), new StreamResult(writer));
            writer.write(System.getProperty("line.separator"));
        }
        catch (ParserConfigurationException pce) {
            throw new RKCheckException(pce);
        }
        catch (TransformerException te) {
            throw new RKCheckException(te);
        }
    }

    private void indent(Document document, Element element, String base, String increment) {
        String newBase = base + increment;
        boolean indented = false;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            indented = true;
            element.insertBefore(document.createTextNode("\n" + newBase), node);
            this.indent(document, (Element)node, newBase, increment);
        }
        if (indented) {
            element.appendChild(document.createTextNode("\n" + base));
        }
    }

    protected Element getElement(Node parent, String name, boolean missingOK) throws RKCheckException {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNodeName().equals(name)) continue;
            return (Element)node;
        }
        if (missingOK) {
            return null;
        }
        throw new RKCheckException("element {0} cannot be found in file {1}", new String[]{name, this.uri});
    }

    protected String getAttribute(Node element, String name, boolean missingOK) throws RKCheckException {
        Attr attribute = ((Element)element).getAttributeNode(name);
        if (attribute == null && !missingOK) {
            throw new RKCheckException("missing {0} attribute in {1}", new String[]{name, this.uri});
        }
        return attribute == null ? null : attribute.getValue();
    }

    protected String getContent(Node node) throws RKCheckException {
        StringBuffer buffer = new StringBuffer();
        block5: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 3: {
                    buffer.append(child.getNodeValue());
                    continue block5;
                }
                case 5: {
                    buffer.append(this.getContent(child));
                    continue block5;
                }
                case 4: {
                    buffer.append(child.getNodeValue());
                    continue block5;
                }
                default: {
                    throw new RKCheckException("unexpected content in element {0} of file {1}", new String[]{node.getNodeName(), this.uri});
                }
            }
        }
        return buffer.toString();
    }

    @Override
    public void error(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    public abstract void analyze(Document var1, String var2) throws RKCheckException, NumberFormatException;

    public abstract void build(Document var1, String var2) throws RKCheckException;

    protected abstract String getPublicId();

    protected abstract String getSystemId();
}

