/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.rkcheck;

import java.math.BigDecimal;
import java.math.BigInteger;

public class QuadraticSurd {
    private BigInteger p1;
    private BigInteger p2;
    private BigInteger d;
    private BigInteger q;
    private static long[] primes = new long[]{2L, 3L, 5L, 7L, 11L, 13L, 17L, 19L, 23L, 29L, 31L, 37L, 41L, 43L, 47L, 53L, 59L, 61L, 67L, 71L, 73L, 79L, 83L, 89L, 97L, 101L, 103L, 107L, 109L, 113L, 127L, 131L, 137L, 139L, 149L, 151L, 157L, 163L, 167L, 173L, 179L, 181L, 191L, 193L, 197L, 199L, 211L, 223L, 227L, 229L, 233L, 239L, 241L, 251L, 257L, 263L, 269L, 271L, 277L, 281L, 283L, 293L, 307L, 311L, 313L, 317L, 331L, 337L, 347L, 349L, 353L, 359L, 367L, 373L, 379L, 383L, 389L, 397L, 401L, 409L, 419L, 421L, 431L, 433L, 439L, 443L, 449L, 457L, 461L, 463L, 467L, 479L, 487L, 491L, 499L, 503L, 509L, 521L, 523L, 541L, 547L, 557L, 563L, 569L, 571L, 577L, 587L, 593L, 599L, 601L, 607L, 613L, 617L, 619L, 631L, 641L, 643L, 647L, 653L, 659L, 661L, 673L, 677L, 683L, 691L, 701L, 709L, 719L, 727L, 733L, 739L, 743L, 751L, 757L, 761L, 769L, 773L, 787L, 797L, 809L, 811L, 821L, 823L, 827L, 829L, 839L, 853L, 857L, 859L, 863L, 877L, 881L, 883L, 887L, 907L, 911L, 919L, 929L, 937L, 941L, 947L, 953L, 967L, 971L, 977L, 983L, 991L, 997L, 1009L, 1013L, 1019L, 1021L, 1031L, 1033L, 1039L, 1049L, 1051L, 1061L, 1063L, 1069L, 1087L, 1091L, 1093L, 1097L, 1103L, 1109L, 1117L, 1123L, 1129L, 1151L, 1153L, 1163L, 1171L, 1181L, 1187L, 1193L, 1201L, 1213L, 1217L, 1223L, 1229L, 1231L, 1237L, 1249L, 1259L, 1277L, 1279L, 1283L, 1289L, 1291L, 1297L, 1301L, 1303L, 1307L, 1319L, 1321L, 1327L, 1361L, 1367L, 1373L, 1381L, 1399L, 1409L, 1423L, 1427L, 1429L, 1433L, 1439L, 1447L, 1451L, 1453L, 1459L, 1471L, 1481L, 1483L, 1487L, 1489L, 1493L, 1499L, 1511L, 1523L, 1531L, 1543L, 1549L, 1553L, 1559L, 1567L, 1571L, 1579L, 1583L, 1597L, 1601L, 1607L, 1609L, 1613L, 1619L, 1621L, 1627L, 1637L, 1657L, 1663L, 1667L, 1669L, 1693L, 1697L, 1699L, 1709L, 1721L, 1723L, 1733L, 1741L, 1747L, 1753L, 1759L, 1777L, 1783L, 1787L, 1789L, 1801L, 1811L, 1823L, 1831L, 1847L, 1861L, 1867L, 1871L, 1873L, 1877L, 1879L, 1889L, 1901L, 1907L, 1913L, 1931L, 1933L, 1949L, 1951L, 1973L, 1979L, 1987L, 1993L, 1997L, 1999L, 2003L, 2011L, 2017L, 2027L, 2029L, 2039L, 2053L, 2063L, 2069L, 2081L, 2083L, 2087L, 2089L, 2099L, 2111L, 2113L, 2129L, 2131L, 2137L, 2141L, 2143L, 2153L, 2161L, 2179L, 2203L, 2207L, 2213L, 2221L, 2237L, 2239L, 2243L, 2251L, 2267L, 2269L, 2273L, 2281L, 2287L, 2293L, 2297L, 2309L, 2311L, 2333L, 2339L, 2341L, 2347L, 2351L, 2357L, 2371L, 2377L, 2381L, 2383L, 2389L, 2393L, 2399L, 2411L, 2417L, 2423L, 2437L, 2441L, 2447L, 2459L, 2467L, 2473L, 2477L, 2503L, 2521L, 2531L, 2539L, 2543L, 2549L, 2551L, 2557L, 2579L, 2591L, 2593L, 2609L, 2617L, 2621L, 2633L, 2647L, 2657L, 2659L, 2663L, 2671L, 2677L, 2683L, 2687L, 2689L, 2693L, 2699L, 2707L, 2711L, 2713L, 2719L, 2729L, 2731L, 2741L, 2749L, 2753L, 2767L, 2777L, 2789L, 2791L, 2797L, 2801L, 2803L, 2819L, 2833L, 2837L, 2843L, 2851L, 2857L, 2861L, 2879L, 2887L, 2897L, 2903L, 2909L, 2917L, 2927L, 2939L, 2953L, 2957L, 2963L, 2969L, 2971L, 2999L, 3001L, 3011L, 3019L, 3023L, 3037L, 3041L, 3049L, 3061L, 3067L, 3079L, 3083L, 3089L, 3109L, 3119L, 3121L, 3137L, 3163L, 3167L, 3169L, 3181L, 3187L, 3191L, 3203L, 3209L, 3217L, 3221L, 3229L, 3251L, 3253L, 3257L, 3259L, 3271L, 3299L, 3301L, 3307L, 3313L, 3319L, 3323L, 3329L, 3331L, 3343L, 3347L, 3359L, 3361L, 3371L, 3373L, 3389L, 3391L, 3407L, 3413L, 3433L, 3449L, 3457L, 3461L, 3463L, 3467L, 3469L, 3491L, 3499L, 3511L, 3517L, 3527L, 3529L, 3533L, 3539L, 3541L, 3547L, 3557L, 3559L, 3571L, 3581L, 3583L, 3593L, 3607L, 3613L, 3617L, 3623L, 3631L, 3637L, 3643L, 3659L, 3671L, 3673L, 3677L, 3691L, 3697L, 3701L, 3709L, 3719L, 3727L, 3733L, 3739L, 3761L, 3767L, 3769L, 3779L, 3793L, 3797L, 3803L, 3821L, 3823L, 3833L, 3847L, 3851L, 3853L, 3863L, 3877L, 3881L, 3889L, 3907L, 3911L, 3917L, 3919L, 3923L, 3929L, 3931L, 3943L, 3947L, 3967L, 3989L, 4001L, 4003L, 4007L, 4013L, 4019L, 4021L, 4027L, 4049L, 4051L, 4057L, 4073L, 4079L, 4091L, 4093L, 4099L, 4111L, 4127L, 4129L, 4133L, 4139L, 4153L, 4157L, 4159L, 4177L, 4201L, 4211L, 4217L, 4219L, 4229L, 4231L, 4241L, 4243L, 4253L, 4259L, 4261L, 4271L, 4273L, 4283L, 4289L, 4297L, 4327L, 4337L, 4339L, 4349L, 4357L, 4363L, 4373L, 4391L, 4397L, 4409L, 4421L, 4423L, 4441L, 4447L, 4451L, 4457L, 4463L, 4481L, 4483L, 4493L, 4507L, 4513L, 4517L, 4519L, 4523L, 4547L, 4549L, 4561L, 4567L, 4583L, 4591L, 4597L, 4603L, 4621L, 4637L, 4639L, 4643L, 4649L, 4651L, 4657L, 4663L, 4673L, 4679L, 4691L, 4703L, 4721L, 4723L, 4729L, 4733L, 4751L, 4759L, 4783L, 4787L, 4789L, 4793L, 4799L, 4801L, 4813L, 4817L, 4831L, 4861L, 4871L, 4877L, 4889L, 4903L, 4909L, 4919L, 4931L, 4933L, 4937L, 4943L, 4951L, 4957L, 4967L, 4969L, 4973L, 4987L, 4993L, 4999L};

    public QuadraticSurd() {
        this.p1 = BigInteger.ZERO;
        this.p2 = BigInteger.ZERO;
        this.d = BigInteger.ZERO;
        this.q = BigInteger.ONE;
    }

    public QuadraticSurd(long l) {
        this.p1 = BigInteger.valueOf(l);
        this.p2 = BigInteger.ZERO;
        this.d = BigInteger.ZERO;
        this.q = BigInteger.ONE;
    }

    public QuadraticSurd(BigInteger l) {
        this.p1 = l;
        this.p2 = BigInteger.ZERO;
        this.d = BigInteger.ZERO;
        this.q = BigInteger.ONE;
    }

    public QuadraticSurd(long numerator, long denominator) {
        this(BigInteger.valueOf(numerator), BigInteger.ZERO, BigInteger.ZERO, BigInteger.valueOf(denominator));
    }

    public QuadraticSurd(BigInteger numerator, BigInteger denominator) {
        this(numerator, BigInteger.ZERO, BigInteger.ZERO, denominator);
    }

    public QuadraticSurd(long p1, long p2, long d, long q) {
        this(BigInteger.valueOf(p1), BigInteger.valueOf(p2), BigInteger.valueOf(d), BigInteger.valueOf(q));
    }

    public QuadraticSurd(BigInteger p1, BigInteger p2, BigInteger d, BigInteger q) {
        if (d.signum() < 0) {
            throw new ArithmeticException("negative root");
        }
        if (q.signum() == 0) {
            throw new ArithmeticException("divide by zero");
        }
        this.p1 = p1;
        this.p2 = p2;
        this.d = d;
        this.q = q;
        this.simplify();
    }

    public QuadraticSurd(BigDecimal r, BigDecimal tolerance) {
        this.p2 = BigInteger.ZERO;
        this.d = BigInteger.ZERO;
        boolean negative = r.signum() < 0;
        BigDecimal a = negative ? r.negate() : r;
        BigInteger An2 = BigInteger.ZERO;
        BigInteger Bn2 = BigInteger.ONE;
        BigInteger An1 = BigInteger.ONE;
        BigInteger Bn1 = BigInteger.ZERO;
        BigDecimal zero = new BigDecimal(BigInteger.ZERO);
        BigDecimal one = new BigDecimal(BigInteger.ONE);
        do {
            BigInteger p = a.toBigInteger();
            BigInteger An = p.multiply(An1).add(An2);
            this.p1 = negative ? An.negate() : An;
            this.q = p.multiply(Bn1).add(Bn2);
            if ((a = a.subtract(new BigDecimal(p))).compareTo(zero) == 0) {
                return;
            }
            a = one.divide(a, r.scale(), 6);
            An2 = An1;
            An1 = An;
            Bn2 = Bn1;
            Bn1 = this.q;
        } while (this.bigDecimalValue(r.scale()).subtract(r).abs().compareTo(tolerance) > 0);
    }

    public QuadraticSurd(QuadraticSurd qs) {
        this.p1 = qs.p1;
        this.p2 = qs.p2;
        this.d = qs.d;
        this.q = qs.q;
    }

    public boolean sameField(QuadraticSurd qs) {
        return this.p2.signum() == 0 || qs.p2.signum() == 0 || this.d.compareTo(qs.d) == 0;
    }

    private void chokeIfDifferentField(QuadraticSurd qs) throws ArithmeticException {
        if (!this.sameField(qs)) {
            throw new ArithmeticException("forbidden operation between quadratic surds belonging to different fields: " + this + " vs. " + qs);
        }
    }

    public void negateSelf() {
        this.p1 = this.p1.negate();
        this.p2 = this.p2.negate();
    }

    public static QuadraticSurd negate(QuadraticSurd qs) {
        QuadraticSurd copy = new QuadraticSurd(qs);
        copy.negateSelf();
        return copy;
    }

    public void addToSelf(QuadraticSurd qs) throws ArithmeticException {
        this.chokeIfDifferentField(qs);
        if (this.p2.signum() == 0) {
            this.d = qs.d;
        }
        this.p1 = this.p1.multiply(qs.q).add(this.q.multiply(qs.p1));
        this.p2 = this.p2.multiply(qs.q).add(this.q.multiply(qs.p2));
        this.q = this.q.multiply(qs.q);
        this.simplify();
    }

    public static QuadraticSurd add(QuadraticSurd qs1, QuadraticSurd qs2) throws ArithmeticException {
        QuadraticSurd copy = new QuadraticSurd(qs1);
        copy.addToSelf(qs2);
        return copy;
    }

    public void subtractFromSelf(QuadraticSurd qs) throws ArithmeticException {
        this.chokeIfDifferentField(qs);
        if (this.p2.signum() == 0) {
            this.d = qs.d;
        }
        this.p1 = this.p1.multiply(qs.q).subtract(this.q.multiply(qs.p1));
        this.p2 = this.p2.multiply(qs.q).subtract(this.q.multiply(qs.p2));
        this.q = this.q.multiply(qs.q);
        this.simplify();
    }

    public static QuadraticSurd subtract(QuadraticSurd qs1, QuadraticSurd qs2) throws ArithmeticException {
        QuadraticSurd copy = new QuadraticSurd(qs1);
        copy.subtractFromSelf(qs2);
        return copy;
    }

    public void multiplySelf(long l) {
        BigInteger bl = BigInteger.valueOf(l);
        this.p1 = this.p1.multiply(bl);
        this.p2 = this.p2.multiply(bl);
        this.simplify();
    }

    public static QuadraticSurd multiply(QuadraticSurd qs, long l) {
        QuadraticSurd copy = new QuadraticSurd(qs);
        copy.multiplySelf(l);
        return copy;
    }

    public void multiplySelf(QuadraticSurd qs) throws ArithmeticException {
        this.chokeIfDifferentField(qs);
        if (this.p2.signum() == 0) {
            this.d = qs.d;
        }
        BigInteger newP1 = this.p1.multiply(qs.p1).add(this.p2.multiply(qs.p2).multiply(this.d));
        this.p2 = this.p1.multiply(qs.p2).add(this.p2.multiply(qs.p1));
        this.p1 = newP1;
        this.q = this.q.multiply(qs.q);
        this.simplify();
    }

    public static QuadraticSurd multiply(QuadraticSurd qs1, QuadraticSurd qs2) throws ArithmeticException {
        QuadraticSurd copy = new QuadraticSurd(qs1);
        copy.multiplySelf(qs2);
        return copy;
    }

    public void divideSelf(long l) throws ArithmeticException {
        if (l == 0L) {
            throw new ArithmeticException("divide by zero");
        }
        this.q = this.q.multiply(BigInteger.valueOf(l));
        this.simplify();
    }

    public static QuadraticSurd divide(QuadraticSurd qs, long l) throws ArithmeticException {
        QuadraticSurd copy = new QuadraticSurd(qs);
        copy.divideSelf(l);
        return copy;
    }

    public void divideSelf(QuadraticSurd qs) throws ArithmeticException {
        this.multiplySelf(QuadraticSurd.invert(qs));
    }

    public static QuadraticSurd divide(QuadraticSurd qs1, QuadraticSurd qs2) {
        QuadraticSurd copy = new QuadraticSurd(qs1);
        copy.divideSelf(qs2);
        return copy;
    }

    public void invertSelf() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException("divide by zero");
        }
        BigInteger newP1 = this.q.multiply(this.p1);
        BigInteger newP2 = this.q.multiply(this.p2).negate();
        this.q = this.p1.multiply(this.p1).subtract(this.d.multiply(this.p2).multiply(this.p2));
        this.p1 = newP1;
        this.p2 = newP2;
        this.simplify();
    }

    public static QuadraticSurd invert(QuadraticSurd qs) throws ArithmeticException {
        QuadraticSurd copy = new QuadraticSurd(qs);
        copy.invertSelf();
        return copy;
    }

    public boolean isZero() {
        return this.p1.signum() == 0 && this.p2.signum() == 0;
    }

    public boolean isOne() {
        return this.p1.compareTo(BigInteger.ONE) == 0 && this.p2.signum() == 0 && this.q.compareTo(BigInteger.ONE) == 0;
    }

    public boolean isInteger() {
        return this.p2.signum() == 0 && this.q.compareTo(BigInteger.ONE) == 0;
    }

    public boolean isRational() {
        return this.p2.signum() == 0;
    }

    public boolean equals(Object o) {
        if (o instanceof QuadraticSurd) {
            QuadraticSurd qs = (QuadraticSurd)o;
            return this.p1.compareTo(qs.p1) == 0 && this.p2.compareTo(qs.p2) == 0 && this.d.compareTo(qs.d) == 0 && this.q.compareTo(qs.q) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.p1.hashCode() << 12 ^ this.p2.hashCode() << 8 ^ this.d.hashCode() << 4 ^ this.q.hashCode();
    }

    private void simplify() {
        long squaredPrime;
        if (this.isZero()) {
            this.d = BigInteger.ZERO;
            this.q = BigInteger.ONE;
            return;
        }
        if (this.q.signum() < 0) {
            this.p1 = this.p1.negate();
            this.p2 = this.p2.negate();
            this.q = this.q.negate();
        }
        int k = 0;
        do {
            if (this.d.remainder(BigInteger.valueOf(squaredPrime = primes[k] * primes[k])).signum() == 0) {
                this.d = this.d.divide(BigInteger.valueOf(squaredPrime));
                this.p2 = this.p2.multiply(BigInteger.valueOf(primes[k]));
                continue;
            }
            ++k;
        } while (k < primes.length && this.d.compareTo(BigInteger.valueOf(squaredPrime)) >= 0);
        BigInteger gcd = this.q.gcd(this.p1.gcd(this.p2));
        if (gcd.compareTo(BigInteger.ONE) > 0) {
            this.p1 = this.p1.divide(gcd);
            this.p2 = this.p2.divide(gcd);
            this.q = this.q.divide(gcd);
        }
    }

    public BigInteger getRationalNumerator() {
        return this.p1;
    }

    public BigInteger getRootCoefficient() {
        return this.p2;
    }

    public BigInteger getRootElement() {
        return this.d;
    }

    public BigInteger getDenominator() {
        return this.q;
    }

    public double doubleValue() {
        if (this.p2.signum() == 0) {
            return this.p1.doubleValue() / this.q.doubleValue();
        }
        return (this.p1.doubleValue() + this.p2.doubleValue() * Math.sqrt(this.d.doubleValue())) / this.q.doubleValue();
    }

    public BigDecimal bigDecimalValue(int scale) {
        BigDecimal oldS;
        BigDecimal den;
        BigDecimal s2;
        BigDecimal num;
        if (this.p2.signum() == 0) {
            return new BigDecimal(this.p1).divide(new BigDecimal(this.q), scale, 6);
        }
        BigDecimal s = new BigDecimal(Math.sqrt(this.d.doubleValue()));
        BigDecimal bdD = new BigDecimal(this.d);
        s = s.setScale(scale, 6);
        do {
            oldS = s;
        } while ((s = (num = s.multiply((s2 = s.multiply(s)).add(BigDecimal.valueOf(3L).multiply(bdD)))).divide(den = s2.multiply(BigDecimal.valueOf(3L)).add(bdD), scale, 6)).subtract(oldS).abs().signum() != 0);
        BigDecimal a = new BigDecimal(this.p1).add(new BigDecimal(this.p2).multiply(s));
        return a.divide(new BigDecimal(this.q), scale, 6);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.p1.signum() == 0 && this.p2.signum() == 0) {
            return "0";
        }
        if (this.p1.signum() != 0) {
            sb.append(this.p1);
            if (this.p2.signum() != 0) {
                sb.append(this.p2.signum() < 0 ? " -" : " +");
                if (this.p2.abs().compareTo(BigInteger.ONE) != 0) {
                    sb.append(' ');
                    sb.append(this.p2.abs());
                }
                sb.append(" sqrt(");
                sb.append(this.d);
                sb.append(')');
            }
        } else if (this.p2.signum() != 0) {
            sb.append(this.p2.signum() < 0 ? (char)'-' : '+');
            if (this.p2.abs().compareTo(BigInteger.ONE) != 0) {
                sb.append(' ');
                sb.append(this.p2.abs());
            }
            sb.append(" sqrt(");
            sb.append(this.d);
            sb.append(')');
        }
        if (this.q.compareTo(BigInteger.ONE) != 0) {
            if (sb.indexOf(" ") > 0) {
                sb.insert(0, '(');
                sb.append(')');
            }
            sb.append(" / ");
            sb.append(this.q);
        }
        return sb.toString();
    }
}

