/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.rkcheck;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EmbeddedCatalogResolver
implements EntityResolver {
    String base;
    String catalogName;
    DocumentBuilder builder;
    HashMap map;

    public EmbeddedCatalogResolver(String catalog, DocumentBuilder builder) {
        int index = catalog.lastIndexOf(47);
        if (index < 0) {
            this.base = "";
            this.catalogName = catalog;
        } else {
            this.base = catalog.substring(0, index + 1);
            this.catalogName = catalog.substring(index + 1);
        }
        this.map = new HashMap();
        this.builder = builder;
        builder.setEntityResolver(this);
    }

    public String getResourceName(String publicId) throws IOException, SAXException {
        if (publicId.equals("-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN")) {
            return this.base + "catalog.dtd";
        }
        if (this.map.isEmpty()) {
            this.parseCatalog();
        }
        return (String)this.map.get(publicId);
    }

    private void parseCatalog() throws SAXException, IOException {
        InputStream is = this.getClass().getResourceAsStream(this.base + this.catalogName);
        if (is == null) {
            return;
        }
        Document document = this.builder.parse(is);
        for (Node child = document.getDocumentElement().getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals("public")) continue;
            String publicId = ((Element)child).getAttribute("publicId");
            String uri = ((Element)child).getAttribute("uri");
            if (publicId == null || uri == null) continue;
            this.map.put(publicId, uri.startsWith("/") ? uri : this.base + uri);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            String resourceName = this.getResourceName(publicId);
            if (resourceName != null) {
                InputStream is = this.getClass().getResourceAsStream(resourceName);
                return is != null ? new InputSource(is) : null;
            }
            return null;
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }
}

