/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.scale.klotzTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.tests.StatisticalTest;

public class KlotzTest
extends StatisticalTest {
    private DataTable data;
    private double[] sample1;
    private double[] sample2;
    private int values1;
    private int values2;
    private double[] combined;
    private int N;
    private double[] weights;
    private double sumWeights;
    private double quadSumWeights;
    private double MNx;
    private double MNy;
    private double xPValue;
    private double yPValue;
    private NormalDistribution normal;

    public KlotzTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.MNx = 0.0;
        this.MNy = 0.0;
        this.sample1 = null;
        this.sample2 = null;
        this.weights = null;
        this.xPValue = -1.0;
        this.yPValue = -1.0;
    }

    public KlotzTest(DataTable newData) {
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Klotz test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.values1 = this.data.getRows() - nulls;
        this.sample1 = new double[this.values1];
        nulls = this.data.getColumnNulls(1);
        this.values2 = this.data.getRows() - nulls;
        this.sample2 = new double[this.values2];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Klotz test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.values1 = this.data.getRows() - nulls;
        this.sample1 = new double[this.values1];
        nulls = this.data.getColumnNulls(1);
        this.values2 = this.data.getRows() - nulls;
        this.sample2 = new double[this.values2];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.combined = new double[this.sample1.length + this.sample2.length];
        Arrays.sort(this.sample1);
        Arrays.sort(this.sample2);
        System.arraycopy(this.sample1, 0, this.combined, 0, this.sample1.length);
        System.arraycopy(this.sample2, 0, this.combined, this.sample1.length, this.sample2.length);
        Arrays.sort(this.combined);
        this.N = this.sample1.length + this.sample2.length;
        this.weights = new double[this.N];
        this.generateWeights();
        this.MNx = 0.0;
        this.MNy = 0.0;
        int pointer2 = 0;
        for (int pointer = 0; pointer < this.sample1.length; ++pointer) {
            while (this.combined[pointer2] != this.sample1[pointer]) {
                ++pointer2;
            }
            this.MNx += this.weights[pointer2];
        }
        this.MNy = this.sumWeights - this.MNx;
        this.computePValues();
        this.performed = true;
    }

    private void generateWeights() {
        this.sumWeights = 0.0;
        this.quadSumWeights = 0.0;
        this.normal = new NormalDistribution();
        for (int i = 1; i <= this.N; ++i) {
            double value;
            double aux = this.normal.inverseNormalDistribution((double)i / ((double)this.N + 1.0));
            this.weights[i - 1] = value = aux * aux;
            this.sumWeights += value;
            this.quadSumWeights += value * value;
        }
    }

    private void computePValues() {
        double numerator = this.MNx - (double)this.values1 / (double)this.N * this.sumWeights;
        double value = (double)this.values1 * (double)this.values2 / ((double)this.N * ((double)this.N - 1.0)) * this.quadSumWeights;
        double denominator = Math.sqrt(value -= (double)this.values2 / ((double)this.values1 * ((double)this.N - 1.0)) * (numerator * numerator));
        double z = numerator / denominator;
        this.xPValue = this.normal.getTipifiedProbability(z, false);
        numerator = this.MNy - (double)this.values1 / (double)this.N * this.sumWeights;
        value = (double)this.values1 * (double)this.values2 / ((double)this.N * ((double)this.N - 1.0)) * this.quadSumWeights;
        denominator = Math.sqrt(value -= (double)this.values2 / ((double)this.values1 * ((double)this.N - 1.0)) * (numerator * numerator));
        z = numerator / denominator;
        this.yPValue = this.normal.getTipifiedProbability(z, false);
    }

    public double getTestStatistic1() {
        return this.MNx;
    }

    public double getTestStatistic2() {
        return this.MNy;
    }

    public double getPValue1() {
        return this.xPValue;
    }

    public double getPValue2() {
        return this.yPValue;
    }

    public String printWeights() {
        String text = "";
        for (int i = 0; i < this.weights.length; ++i) {
            text = text + this.weights[i] + " ";
        }
        return text;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n************\n";
        report = report + "Klotz test\n";
        report = report + "**************\n\n";
        report = report + "Klotz Statistic X: " + this.nf6.format(this.MNx) + "\n";
        report = report + "Klotz Statistic Y: " + this.nf6.format(this.MNy) + "\n\n";
        report = report + "Asymptotic P-Value (X): " + this.nf6.format(this.xPValue) + "\n";
        report = report + "Asymptotic P-Value (Y): " + this.nf6.format(this.yPValue) + "\n\n";
        return report;
    }
}

