/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.oneSample.wilcoxonTest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.tests.WilcoxonDistribution;
import javanpst.tests.StatisticalTest;

public class WilcoxonTest
extends StatisticalTest {
    private WilcoxonDistribution distribution = WilcoxonDistribution.getInstance();
    private DataTable data;
    private double rPlus;
    private double rMinus;
    private double exactLeftTail;
    private double exactRightTail;
    private double exactDoubleTail;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;
    double upper90;
    double upper95;
    double lower90;
    double lower95;
    double exactConfidence90;
    double exactConfidence95;

    public WilcoxonTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.rPlus = 0.0;
        this.rMinus = 0.0;
        this.upper90 = 0.0;
        this.upper95 = 0.0;
        this.lower90 = 0.0;
        this.lower95 = 0.0;
        this.exactLeftTail = -1.0;
        this.exactRightTail = -1.0;
        this.exactDoubleTail = -1.0;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
        this.data = new DataTable();
        this.dataReady = false;
        this.performed = false;
    }

    public WilcoxonTest(DataTable newData) {
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Wilcoxon test only can be employed with two samples");
            this.clearData();
            return;
        }
        for (int i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Wilcoxon test only can be employed with two samples");
            this.clearData();
            return;
        }
        for (int i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        int tied;
        int i;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        double[] AOld = new double[this.data.getRows()];
        double[] BOld = new double[this.data.getRows()];
        double[] diffOld = new double[this.data.getRows()];
        int zeroDifferences = 0;
        double tiesWeight = 0.0;
        for (i = 0; i < this.data.getRows(); ++i) {
            AOld[i] = this.data.get(i, 0);
            BOld[i] = this.data.get(i, 1);
            diffOld[i] = Math.abs(AOld[i] - BOld[i]);
            if (diffOld[i] != 0.0) continue;
            ++zeroDifferences;
        }
        int N = this.data.getRows() - zeroDifferences;
        double[] A = new double[N];
        double[] B = new double[N];
        double[] diff = new double[N];
        boolean[] sign = new boolean[N];
        double[] ranks = new double[N];
        int pointer = 0;
        for (i = 0; i < this.data.getRows(); ++i) {
            if (diffOld[i] == 0.0) continue;
            A[pointer] = AOld[i];
            B[pointer] = BOld[i];
            diff[pointer] = Math.abs(A[pointer] - B[pointer]);
            sign[pointer] = A[pointer] - B[pointer] > 0.0;
            ++pointer;
        }
        Arrays.fill(ranks, -1.0);
        for (int rank = 1; rank <= N; rank += tied) {
            double points;
            int i2;
            double min = Double.MAX_VALUE;
            tied = 1;
            for (i2 = 0; i2 < N; ++i2) {
                if (ranks[i2] == -1.0 && diff[i2] == min) {
                    ++tied;
                }
                if (ranks[i2] != -1.0 || !(diff[i2] < min)) continue;
                min = diff[i2];
                tied = 1;
            }
            if (tied == 1) {
                points = rank;
            } else {
                points = 0.0;
                for (int k = 0; k < tied; ++k) {
                    points += (double)(rank + k);
                }
                points /= (double)tied;
                tiesWeight += (double)tied * ((double)(tied * tied) - 1.0);
            }
            for (i2 = 0; i2 < N; ++i2) {
                if (diff[i2] != min) continue;
                ranks[i2] = points;
            }
        }
        this.rPlus = 0.0;
        this.rMinus = 0.0;
        for (int i3 = 0; i3 < ranks.length; ++i3) {
            if (sign[i3]) {
                this.rPlus += ranks[i3];
                continue;
            }
            this.rMinus += ranks[i3];
        }
        if (zeroDifferences > 1) {
            double increment = zeroDifferences % 2 == 1 ? (double)zeroDifferences - 1.0 : (double)zeroDifferences;
            double sum0 = ((double)zeroDifferences + 1.0) * (double)zeroDifferences / 2.0;
            this.rPlus += (sum0 /= 2.0);
            this.rMinus += sum0;
            for (int i4 = 0; i4 < ranks.length; ++i4) {
                if (sign[i4]) {
                    this.rPlus += increment;
                    continue;
                }
                this.rMinus += increment;
            }
        }
        double aux1 = this.distribution.computeExactProbability(N, this.rPlus);
        double aux2 = this.distribution.computeExactProbability(N, this.rMinus);
        if (aux1 == 1.0 && aux2 == 1.0) {
            this.exactLeftTail = 1.0;
            this.exactRightTail = 1.0;
            this.exactDoubleTail = 1.0;
        } else if (aux1 != 1.0) {
            this.exactDoubleTail = aux1;
            this.exactLeftTail = this.exactDoubleTail / 2.0;
            this.exactRightTail = 1.0 - this.exactLeftTail;
        } else {
            this.exactDoubleTail = aux2;
            this.exactRightTail = this.exactDoubleTail / 2.0;
            this.exactLeftTail = 1.0 - this.exactRightTail;
        }
        this.asymptoticLeftTail = this.distribution.computeAsymptoticLeftTailProbability(N, this.rPlus, tiesWeight);
        this.asymptoticRightTail = this.distribution.computeAsymptoticRightTailProbability(N, this.rPlus, tiesWeight);
        this.asymptoticDoubleTail = this.distribution.computeAsymptoticDoubleTailProbability(N, this.rPlus, tiesWeight);
        ArrayList<Double> walsh = new ArrayList<Double>();
        for (int i5 = 0; i5 < diffOld.length - 1; ++i5) {
            double aux = AOld[i5] - BOld[i5];
            walsh.add(aux);
            for (int j = i5 + 1; j < diffOld.length; ++j) {
                aux2 = AOld[j] - BOld[j];
                walsh.add((aux + aux2) / 2.0);
            }
        }
        Collections.sort(walsh);
        int criticalN = this.findCriticalValue(diffOld.length, 0.05);
        criticalN = Math.max(criticalN, 0);
        this.lower95 = (Double)walsh.get(criticalN);
        this.upper95 = (Double)walsh.get(walsh.size() - (criticalN + 1));
        this.exactConfidence95 = 1.0 - this.distribution.computeExactProbability(diffOld.length, criticalN);
        criticalN = this.findCriticalValue(diffOld.length, 0.1);
        this.lower90 = (Double)walsh.get(criticalN);
        this.upper90 = (Double)walsh.get(walsh.size() - (criticalN + 1));
        this.exactConfidence90 = 1.0 - this.distribution.computeExactProbability(diffOld.length, criticalN);
        this.performed = true;
    }

    private int findCriticalValue(int N, double alpha) {
        double limit = alpha;
        int critical = -1;
        while (this.distribution.computeExactProbability(N, ++critical) < limit) {
        }
        return --critical;
    }

    public double getRPlus() {
        return this.rPlus;
    }

    public double getRMinus() {
        return this.rMinus;
    }

    public double getExactLeftPValue() {
        return this.exactLeftTail;
    }

    public double getExactRightPValue() {
        return this.exactRightTail;
    }

    public double getExactDoublePValue() {
        return this.exactDoubleTail;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n************\n";
        report = report + "Wilcoxon test\n";
        report = report + "************\n\n";
        report = report + "R+ statistic (sample 1): " + this.nf6.format(this.rPlus) + "\n";
        report = report + "R- statistic (sample 2): " + this.nf6.format(this.rMinus) + "\n\n";
        if (this.exactDoubleTail != -1.0) {
            report = report + "Exact P-Value (Left tail, Y > X): " + this.nf6.format(this.exactLeftTail) + "\n";
            report = report + "Exact P-Value (Right tail, Y < X): " + this.nf6.format(this.exactRightTail) + "\n";
            report = report + "Exact P-Value (Double tail, Y != X): " + this.nf6.format(this.exactDoubleTail) + "\n\n";
        }
        report = report + "Asymptotic P-Value (Left tail, Y > X): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Asymptotic P-Value (Right tail, Y > X): " + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Asymptotic P-Value (Double tail, Y != X): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        report = report + "Confidence intervals:\n\n";
        report = report + "90% confidence interval: [" + this.nf6.format(this.lower90) + "," + this.nf6.format(this.upper90) + "], exact confidence: " + this.nf6.format(this.exactConfidence90) + "\n";
        report = report + "95% confidence interval: [" + this.nf6.format(this.lower95) + "," + this.nf6.format(this.upper95) + "], exact confidence: " + this.nf6.format(this.exactConfidence95) + "\n";
        return report;
    }
}

