/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.oneSample.confidenceQuantile;

import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.common.discrete.BinomialDistribution;
import javanpst.tests.StatisticalTest;

public class ConfidenceQuantile
extends StatisticalTest {
    private int N;
    private double p;
    private double confidence;
    private double upper;
    private double lower;
    private double r;
    private double s;
    private double exactConfidenceLevel;
    private BinomialDistribution binomial;
    private NormalDistribution normal;

    public ConfidenceQuantile() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.N = 0;
        this.p = 0.0;
        this.confidence = 0.0;
        this.dataReady = false;
        this.performed = false;
    }

    public ConfidenceQuantile(int n, double p, double confidence) {
        this.setReportFormat();
        this.N = n;
        this.p = p;
        this.confidence = confidence;
        this.binomial = new BinomialDistribution();
        this.binomial.setN(this.N);
        this.binomial.setP(p);
        this.normal = new NormalDistribution();
        this.normal.setMean(0.0);
        this.normal.setS(1.0);
        this.dataReady = true;
    }

    public void setSampleSize(int n) {
        this.N = n;
        this.dataReady = true;
    }

    public void setQuantile(double p) {
        this.p = p;
        this.dataReady = true;
    }

    public void setConfidence(double c) {
        this.confidence = c;
        this.dataReady = true;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        double alpha = 1.0 - this.confidence;
        this.lower = this.binomial.getLesserCumulativeProbability(alpha / 2.0);
        if (this.lower != -1.0) {
            this.lower += 1.0;
        }
        this.upper = this.binomial.getUpperCumulativeProbability(1.0 - alpha / 2.0);
        if (this.upper <= (double)this.N) {
            this.upper += 1.0;
        }
        this.exactConfidenceLevel = this.binomial.computeCumulativeProbability(this.upper - 1.0) - this.binomial.computeCumulativeProbability(this.lower - 1.0);
        double term = this.normal.inverseNormalDistribution(1.0 - alpha / 2.0);
        this.r = (double)this.N * this.p + 0.5 - (term *= Math.sqrt((double)this.N * this.p * (1.0 - this.p)));
        this.s = (double)this.N * this.p + 0.5 + term;
        this.r = Math.floor(this.r);
        this.s = Math.ceil(this.s);
        this.performed = true;
    }

    public double getExactLowerLimit() {
        return this.lower;
    }

    public double getExactUpperLimit() {
        return this.upper;
    }

    public double getApproximateLowerLimit() {
        return this.r;
    }

    public double getApproximateUpperLimit() {
        return this.s;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "N: " + this.N + " P: " + this.p + " Confidence: " + this.confidence + "\n";
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        String lowerLimit = this.lower < 1.0 ? "-INFINITY" : this.nf6.format(this.lower);
        String upperLimit = this.upper <= (double)this.N ? this.nf6.format(this.upper) : "+INFINITY";
        String rLimit = this.r < 1.0 ? "-INFINITY" : this.nf6.format(this.r);
        String sLimit = this.s <= (double)this.N ? this.nf6.format(this.s) : "+INFINITY";
        report = report + "\n***************************************\n";
        report = report + "Confidence interval for a population quantile\n";
        report = report + "***************************************\n\n";
        report = report + "Exact confidence interval (binomial): [" + lowerLimit + "," + upperLimit + "]\n";
        report = report + "Confidence: " + this.nf6.format(this.exactConfidenceLevel) + "\n\n";
        report = report + "Approximate confidence interval (normal): [" + rLimit + "," + sLimit + "]\n";
        report = report + "Confidence: " + this.nf6.format(this.confidence) + "\n\n";
        return report;
    }
}

