/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.goodness.lillieforsTest;

import javanpst.data.structures.sequence.NumericSequence;
import javanpst.distributions.common.continuous.ExponentialDistribution;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.tests.LillieforsDistribution;
import javanpst.tests.StatisticalTest;

public class LillieforsTest
extends StatisticalTest {
    private LillieforsDistribution distribution = LillieforsDistribution.getInstance();
    private NumericSequence sequence;
    private double[] Sn;
    private double[] F0;
    private double Dn;
    private boolean distributionReady;
    private int typeDist;
    private NormalDistribution normal;
    private double pValue;
    private ExponentialDistribution exponential;

    public LillieforsTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.sequence = new NumericSequence();
        this.performed = false;
        this.dataReady = false;
        this.distributionReady = false;
        this.typeDist = -1;
        this.Dn = 0.0;
        this.F0 = null;
        this.Sn = null;
        this.pValue = -1.0;
    }

    public LillieforsTest(NumericSequence newSequence) {
        this.setReportFormat();
        this.sequence = new NumericSequence(newSequence);
        this.sequence.sort();
        this.Sn = new double[this.sequence.size()];
        this.F0 = new double[this.sequence.size()];
        this.performed = false;
        this.dataReady = true;
        this.distributionReady = false;
    }

    public void setData(NumericSequence newSequence) {
        this.sequence = new NumericSequence(newSequence);
        this.sequence.sort();
        this.Sn = new double[this.sequence.size()];
        this.F0 = new double[this.sequence.size()];
        this.performed = false;
        this.dataReady = true;
        this.distributionReady = false;
    }

    public void adjustNormal() {
        this.typeDist = 4;
        this.distributionReady = true;
    }

    public void adjustExponential() {
        this.typeDist = 7;
        this.distributionReady = true;
    }

    @Override
    public void doTest() {
        int i;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        if (!this.distributionReady) {
            System.out.println("Distribution to fit is not set");
            return;
        }
        this.Dn = 0.0;
        for (i = 0; i < this.Sn.length; ++i) {
            this.Sn[i] = (double)(i + 1) / (double)this.Sn.length;
        }
        this.estimateParameters();
        if (this.typeDist == 4) {
            for (i = 0; i < this.F0.length; ++i) {
                this.F0[i] = this.normal.computeCumulativeProbability(this.sequence.getSequence().get(i));
            }
        } else {
            for (i = 0; i < this.F0.length; ++i) {
                this.F0[i] = this.exponential.computeCumulativeProbability(this.sequence.getSequence().get(i));
            }
        }
        for (i = 0; i < this.F0.length; ++i) {
            double value = Math.abs(this.Sn[i] - this.F0[i]);
            this.Dn = Math.max(this.Dn, value);
            double value2 = i == 0 ? 0.0 : this.Sn[i - 1];
            value = Math.abs(value2 - this.F0[i]);
            this.Dn = Math.max(this.Dn, value);
        }
        this.pValue = this.typeDist == 4 ? this.distribution.computeProbabilityNormal(this.sequence.size(), this.Dn) : this.distribution.computeProbabilityExponential(this.sequence.size(), this.Dn);
        this.performed = true;
    }

    private void estimateParameters() {
        if (this.typeDist == 4) {
            this.normal = new NormalDistribution();
            double mean = 0.0;
            double sigma = 0.0;
            for (double d : this.sequence.getSequence()) {
                mean += d;
            }
            this.normal.setMean(mean /= (double)this.sequence.size());
            for (double d : this.sequence.getSequence()) {
                sigma += (d - mean) * (d - mean);
            }
            sigma /= (double)this.sequence.size() - 1.0;
            sigma = Math.sqrt(sigma);
            this.normal.setS(sigma);
        } else {
            this.exponential = new ExponentialDistribution();
            double mean = 0.0;
            for (double d : this.sequence.getSequence()) {
                mean += d;
            }
            this.exponential.setMean(mean /= (double)this.sequence.size());
        }
    }

    public double getDn() {
        return this.Dn;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.sequence;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n************\n";
        report = report + "Lilliefors goodness of fit test\n";
        report = report + "**************\n\n";
        switch (this.typeDist) {
            case 4: {
                report = report + "Fitting data to Normal distribution with Mean = " + this.nf6.format(this.normal.getMean()) + " and Sigma = " + this.nf6.format(this.normal.getSigma()) + " )\n\n";
                break;
            }
            case 7: {
                report = report + "Fitting data to Exponential distribution with Mean = " + this.nf6.format(this.exponential.getMean()) + " )\n\n";
            }
        }
        report = report + "Dn Statistic: " + this.nf6.format(this.Dn) + "\n\n";
        report = this.distribution.isApproximate() ? report + "Asymptotic p-value : <= " + this.nf6.format(this.pValue) + "\n" : report + "Exact p-value : <= " + this.nf6.format(this.pValue) + "\n";
        return report;
    }
}

