/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.equality.kruskalWallisTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.ChiSquareDistribution;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.tests.StatisticalTest;

public class KruskalWallisTest
extends StatisticalTest {
    private DataTable data;
    private double[][] samples;
    private double N;
    private double[] combined;
    private double[] ranks;
    private double[] sumRanks;
    private double[] avgRanks;
    private double H;
    private double pValue;
    private double criticalZ90;
    private double criticalZ95;

    public KruskalWallisTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.H = 0.0;
        this.samples = null;
        this.ranks = null;
        this.sumRanks = null;
        this.avgRanks = null;
        this.pValue = -1.0;
    }

    public KruskalWallisTest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Extended median test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        this.combined = new double[this.data.getRows() * this.data.getColumns()];
        this.ranks = new double[this.combined.length];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
                this.combined[i * this.data.getColumns() + j] = this.data.get(i, j);
            }
        }
        Arrays.sort(this.combined);
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Extended median test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        this.combined = new double[this.data.getRows() * this.data.getColumns()];
        this.ranks = new double[this.combined.length];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
                this.combined[i * this.data.getColumns() + j] = this.data.get(i, j);
            }
        }
        Arrays.sort(this.combined);
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        double value;
        int j;
        int i;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        for (i = 0; i < this.combined.length - 1; ++i) {
            if (this.combined[i] != this.combined[i + 1]) {
                this.ranks[i] = i + 1;
                continue;
            }
            int counter = 2;
            double sum = 2 * i + 3;
            while (i + counter < this.combined.length && this.combined[i] == this.combined[i + counter]) {
                sum += (double)(i + counter);
                ++counter;
            }
            double mediumRank = sum / (double)(--counter + 1);
            for (j = 0; j < counter + 1; ++j) {
                this.ranks[i + j] = mediumRank;
            }
            i += counter;
        }
        if (i == this.combined.length - 1) {
            this.ranks[i] = i + 1;
        }
        this.sumRanks = new double[this.samples[0].length];
        this.avgRanks = new double[this.samples[0].length];
        Arrays.fill(this.sumRanks, 0.0);
        for (int sample = 0; sample < this.samples[0].length; ++sample) {
            for (j = 0; j < this.samples.length; ++j) {
                value = this.samples[j][sample];
                boolean found = false;
                int position = -1;
                int k = 0;
                while (!found) {
                    if (this.combined[k] == value) {
                        found = true;
                        position = k;
                    }
                    ++k;
                }
                int n = sample;
                this.sumRanks[n] = this.sumRanks[n] + this.ranks[position];
            }
        }
        for (i = 0; i < this.samples[0].length; ++i) {
            this.avgRanks[i] = this.sumRanks[i] / (double)this.samples.length;
        }
        this.N = this.combined.length;
        double term1 = 12.0 / (this.N * (this.N + 1.0) * (this.N / (double)this.sumRanks.length));
        double term2 = 0.0;
        for (i = 0; i < this.sumRanks.length; ++i) {
            value = this.sumRanks[i] * this.sumRanks[i];
            term2 += value;
        }
        this.H = term1 * term2 - 3.0 * (this.N + 1.0);
        int dF = this.sumRanks.length - 1;
        this.computePValue(dF);
        this.multipleComparisonsProcedure();
        this.performed = true;
    }

    private void multipleComparisonsProcedure() {
        double critical90 = 1.0 - 0.1 / (double)(this.sumRanks.length * (this.sumRanks.length - 1));
        double critical95 = 1.0 - 0.05 / (double)(this.sumRanks.length * (this.sumRanks.length - 1));
        NormalDistribution normal = new NormalDistribution();
        critical90 = normal.inverseNormalDistribution(critical90);
        critical95 = normal.inverseNormalDistribution(critical95);
        double denominator = Math.sqrt(this.N * (this.N + 1.0) / 12.0 * (1.0 / (double)this.data.getRows() + 1.0 / (double)this.data.getRows()));
        this.criticalZ90 = critical90 * denominator;
        this.criticalZ95 = critical95 * denominator;
    }

    private void computePValue(int dF) {
        ChiSquareDistribution chi = new ChiSquareDistribution();
        chi.setDegree(dF);
        this.pValue = chi.computeCumulativeProbability(this.H);
    }

    public double getH() {
        return this.H;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getAvgRanks(int pop) {
        if (pop - 1 > -1 && pop - 1 < this.avgRanks.length) {
            return this.avgRanks[pop - 1];
        }
        return -1.0;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        int j;
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n***************************************\n";
        report = report + "Kruskal-Wallis test\n";
        report = report + "***************************************\n\n";
        report = report + "Sum of ranks:\n";
        for (j = 0; j < this.sumRanks.length; ++j) {
            report = report + "S" + (j + 1) + "\t";
        }
        report = report + "\n";
        for (j = 0; j < this.sumRanks.length; ++j) {
            report = report + this.nf6.format(this.sumRanks[j]) + "\t";
        }
        report = report + "\n";
        report = report + "\n";
        report = report + "Average ranks:\n";
        for (j = 0; j < this.avgRanks.length; ++j) {
            report = report + "S" + (j + 1) + "\t";
        }
        report = report + "\n";
        for (j = 0; j < this.avgRanks.length; ++j) {
            report = report + this.nf6.format(this.avgRanks[j]) + "\t";
        }
        report = report + "\n";
        report = report + "\n";
        report = report + "H statistic: " + this.nf6.format(this.H) + "\n\n";
        report = report + "P-Value computed :" + this.nf6.format(this.pValue) + "\n\n";
        return report;
    }

    public String printMultipleComparisonsProcedureReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n***************************************\n";
        report = report + "Multiple comparisons procedure (Kruskal-Wallis test)\n";
        report = report + "***************************************\n\n";
        report = report + "Critical values: Alpha=0.90: " + this.criticalZ90 + " Alpha=0.95: " + this.criticalZ95 + "\n\n";
        report = report + "Individual comparisons:\n\n";
        for (int first = 0; first < this.data.getColumns() - 1; ++first) {
            for (int second = first + 1; second < this.data.getColumns(); ++second) {
                double Z = Math.abs(this.avgRanks[first] - this.avgRanks[second]);
                report = report + (first + 1) + " vs " + (second + 1) + ": Z= " + Z + "\n\n";
            }
        }
        return report;
    }
}

