/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.countData.multinomialEqualityTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.ChiSquareDistribution;
import javanpst.tests.StatisticalTest;

public class MultinomialEqualityTest
extends StatisticalTest {
    private DataTable data;
    private double[][] samples;
    private double N;
    private double Q;
    private double pValue;

    public MultinomialEqualityTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.Q = 0.0;
        this.samples = null;
        this.pValue = -1.0;
    }

    public MultinomialEqualityTest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getRows() > 2 || this.data.getRows() < 2) {
            System.out.println("Data must be represented in two rows");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getRows() > 2 || this.data.getRows() < 2) {
            System.out.println("Data must be represented in two rows");
            this.clearData();
            return;
        }
        for (i = 0; i < newData.getColumns(); ++i) {
            if (newData.getRowNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        int j;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        double[] sumColumns = new double[this.data.getColumns()];
        Arrays.fill(sumColumns, 0.0);
        double sum1 = 0.0;
        double sum2 = 0.0;
        this.N = 0.0;
        for (j = 0; j < this.data.getColumns(); ++j) {
            int n = j;
            sumColumns[n] = sumColumns[n] + this.samples[0][j];
            int n2 = j;
            sumColumns[n2] = sumColumns[n2] + this.samples[1][j];
            this.N += this.samples[0][j];
            this.N += this.samples[1][j];
            sum1 += this.samples[0][j];
            sum2 += this.samples[1][j];
        }
        double[][] expected = new double[2][this.data.getColumns()];
        for (j = 0; j < this.data.getColumns(); ++j) {
            expected[0][j] = sumColumns[j] * sum1 / this.N;
            expected[1][j] = sumColumns[j] * sum2 / this.N;
        }
        this.Q = 0.0;
        for (j = 0; j < this.data.getColumns(); ++j) {
            this.Q += (this.samples[0][j] - expected[0][j]) * (this.samples[0][j] - expected[0][j]) / expected[0][j];
            this.Q += (this.samples[1][j] - expected[1][j]) * (this.samples[1][j] - expected[1][j]) / expected[1][j];
        }
        int dF = this.data.getColumns() - 1;
        this.pValue = this.computePValue(dF);
        this.performed = true;
    }

    private double computePValue(int dF) {
        ChiSquareDistribution chi = new ChiSquareDistribution();
        chi.setDegree(dF);
        this.pValue = chi.computeCumulativeProbability(this.Q);
        return this.pValue;
    }

    public double getQ() {
        return this.Q;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        int j;
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n*************\n";
        report = report + "Multinomial equality test\n";
        report = report + "*************\n\n";
        report = report + "Q statistic: " + this.nf6.format(this.Q) + "\n";
        report = report + "Asymptotic P-Value: " + this.nf6.format(this.pValue) + "\n\n";
        report = report + "Contingency table\n\n";
        for (j = 0; j < this.samples[0].length; ++j) {
            report = report + this.samples[0][j] + "\t";
        }
        report = report + "\n";
        for (j = 0; j < this.samples[1].length; ++j) {
            report = report + this.samples[1][j] + "\t";
        }
        report = report + "\n\n";
        return report;
    }
}

