/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.countData.mcNemarTest;

import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.tests.McNemarDistribution;
import javanpst.tests.StatisticalTest;

public class McNemarTest
extends StatisticalTest {
    private McNemarDistribution distribution = McNemarDistribution.getInstance();
    private DataTable data;
    private double[][] contingencyTable;
    private double S;
    private double exactPValue;
    private double Z;
    private double asymptoticNormalPValue;
    private double T;
    private double asymptoticChiPValue;

    public McNemarTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.T = 0.0;
        this.Z = 0.0;
        this.S = 0.0;
        this.contingencyTable = null;
        this.asymptoticChiPValue = -1.0;
        this.asymptoticNormalPValue = -1.0;
        this.exactPValue = -1.0;
    }

    public McNemarTest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() > 2 || this.data.getColumns() < 2 || this.data.getRows() > 2 || this.data.getRows() < 2) {
            System.out.println("Data must be represented in two rows and two columns");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.contingencyTable = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.contingencyTable[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() > 2 || this.data.getColumns() < 2 || this.data.getRows() > 2 || this.data.getRows() < 2) {
            System.out.println("Data must be represented in two rows and two columns");
            this.clearData();
            return;
        }
        for (i = 0; i < newData.getColumns(); ++i) {
            if (newData.getRowNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.contingencyTable = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.contingencyTable[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.S = this.contingencyTable[0][1] + this.contingencyTable[1][0];
        this.exactPValue = this.distribution.computeBinomialAdjustment(this.S, this.contingencyTable[0][1]);
        this.Z = (this.contingencyTable[0][1] - this.contingencyTable[1][0] + 0.5) / Math.sqrt(this.contingencyTable[0][1] + this.contingencyTable[1][0]);
        this.asymptoticNormalPValue = this.distribution.computeNormalAdjustment(this.Z);
        this.T = (this.contingencyTable[0][1] - this.contingencyTable[1][0]) * (this.contingencyTable[0][1] - this.contingencyTable[1][0]) / (this.contingencyTable[0][1] + this.contingencyTable[1][0]);
        this.asymptoticChiPValue = this.distribution.computeChiAdjustment(this.T);
        this.performed = true;
    }

    public double getT() {
        return this.T;
    }

    public double getZ() {
        return this.Z;
    }

    public double getS() {
        return this.S;
    }

    public double getExactPValue() {
        return this.exactPValue;
    }

    public double getAsymptoticNormalPValue() {
        return this.asymptoticNormalPValue;
    }

    public double getAsymptoticChiPValue() {
        return this.asymptoticChiPValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n*************\n";
        report = report + "McNemar Test\n";
        report = report + "*************\n\n";
        report = report + "S statistic (Binomial): " + this.nf6.format(this.S) + "\n";
        report = report + "Exact P-Value: " + this.nf6.format(this.exactPValue) + "\n\n";
        report = report + "Z statistic (Normal): " + this.nf6.format(this.Z) + "\n";
        report = report + "Asymptotic P-value: " + this.nf6.format(this.asymptoticNormalPValue) + "\n\n";
        report = report + "T statistic (Chi-square): " + this.nf6.format(this.T) + "\n";
        report = report + "Asymptotic P-value: " + this.nf6.format(this.asymptoticChiPValue) + "\n\n";
        report = report + "Contingency table\n\n";
        report = report + this.contingencyTable[0][0] + "\t" + this.contingencyTable[0][1] + "\n";
        report = report + this.contingencyTable[1][0] + "\t" + this.contingencyTable[1][1] + "\n";
        report = report + "\n";
        return report;
    }
}

