/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.bivariate.kendallTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.tests.KendallDistribution;
import javanpst.tests.StatisticalTest;
import javanpst.utils.Pair;

public class KendallTest
extends StatisticalTest {
    private KendallDistribution distribution = KendallDistribution.getInstance();
    private DataTable data;
    private double[] sample1;
    private double[] sample2;
    private double[] ranks1;
    private double[] ranks2;
    private double[] C;
    private double[] Q;
    private double T;
    private double Z;
    private double n;
    private double positiveDependencePvalue;
    private double negativeDependencePvalue;
    private double noDependencePvalue;
    private double exactPValue;

    public KendallTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.T = 0.0;
        this.Z = 0.0;
        this.n = 0.0;
        this.positiveDependencePvalue = -1.0;
        this.negativeDependencePvalue = -1.0;
        this.noDependencePvalue = -1.0;
        this.exactPValue = -1.0;
    }

    public KendallTest(DataTable newData) {
        int i;
        this.setReportFormat();
        if (newData.getColumns() != 2) {
            System.out.println("This test only can be employed with two samples");
            this.clearData();
            return;
        }
        if (newData.getRows() < 3) {
            System.out.println("This test need samples of size 3 or more");
            this.clearData();
            return;
        }
        for (i = 0; i < newData.getColumns(); ++i) {
            if (newData.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.data = DataTable.newInstance(newData);
        this.dataReady = true;
        this.performed = false;
        this.n = this.data.getRows();
        this.sample1 = new double[(int)this.n];
        this.sample2 = new double[(int)this.n];
        for (i = 0; i < this.data.getRows(); ++i) {
            this.sample1[i] = this.data.get(i, 0);
            this.sample2[i] = this.data.get(i, 1);
        }
    }

    public void setData(DataTable newData) {
        int i;
        if (newData.getColumns() != 2) {
            System.out.println("This test only can be employed with two samples");
            return;
        }
        if (newData.getRows() < 3) {
            System.out.println("This test need samples of size 3 or more");
            this.clearData();
            return;
        }
        for (i = 0; i < newData.getColumns(); ++i) {
            if (newData.getRowNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            return;
        }
        this.data = DataTable.newInstance(newData);
        this.dataReady = true;
        this.performed = false;
        this.n = this.data.getRows();
        this.sample1 = new double[(int)this.n];
        this.sample2 = new double[(int)this.n];
        for (i = 0; i < this.data.getRows(); ++i) {
            this.sample1[i] = this.data.get(i, 0);
            this.sample2[i] = this.data.get(i, 1);
        }
    }

    @Override
    public void doTest() {
        int j;
        int i;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.computeRanks();
        Object[] samples = new Pair[this.sample1.length];
        for (int i2 = 0; i2 < this.sample1.length; ++i2) {
            samples[i2] = new Pair(this.ranks1[i2], this.ranks2[i2]);
        }
        Arrays.sort(samples);
        this.C = new double[samples.length];
        this.Q = new double[samples.length];
        Arrays.fill(this.C, 0.0);
        Arrays.fill(this.Q, 0.0);
        for (i = samples.length - 1; i > 0; --i) {
            double value = ((Pair)samples[i]).b;
            for (j = i - 1; j > -1; --j) {
                if (!(value > ((Pair)samples[j]).b)) continue;
                int n = j;
                this.C[n] = this.C[n] + 1.0;
            }
        }
        for (i = samples.length - 1; i > 0; --i) {
            double value = ((Pair)samples[i]).b;
            for (j = i - 1; j > -1; --j) {
                if (!(value < ((Pair)samples[j]).b)) continue;
                int n = j;
                this.Q[n] = this.Q[n] + 1.0;
            }
        }
        double sumC = 0.0;
        double sumQ = 0.0;
        for (int i3 = 0; i3 < samples.length; ++i3) {
            sumC += this.C[i3];
            sumQ += this.Q[i3];
        }
        this.T = 2.0 * (sumC - sumQ) / (this.n * (this.n - 1.0));
        if (this.n > 2.0 && this.n < 11.0) {
            this.exactPValue = this.distribution.computeExactProbability((int)this.n, this.T);
        } else if (this.n > 10.0 && this.n < 31.0) {
            this.exactPValue = this.distribution.computeApproximatedProbability((int)this.n, this.T);
        }
        double var = 2.0 * (2.0 * this.n + 5.0);
        double numerator = 3.0 * this.T * Math.sqrt(this.n * (this.n - 1.0));
        double stdDev = Math.sqrt(var);
        this.Z = numerator / stdDev;
        this.positiveDependencePvalue = this.distribution.computeAsymptoticProbability(this.Z, true);
        this.negativeDependencePvalue = this.distribution.computeAsymptoticProbability(this.Z, false);
        this.noDependencePvalue = 2.0 * Math.min(this.positiveDependencePvalue, this.negativeDependencePvalue);
        this.performed = true;
    }

    private void computeRanks() {
        int j;
        boolean found;
        double value;
        int i;
        double DELETED = Double.MAX_VALUE;
        double[] copy1 = new double[this.sample1.length];
        double[] copy2 = new double[this.sample2.length];
        System.arraycopy(this.sample1, 0, copy1, 0, this.sample1.length);
        System.arraycopy(this.sample2, 0, copy2, 0, this.sample2.length);
        Arrays.sort(copy1);
        Arrays.sort(copy2);
        this.ranks1 = new double[this.sample1.length];
        this.ranks2 = new double[this.sample2.length];
        for (i = 0; i < this.sample1.length; ++i) {
            value = this.sample1[i];
            found = false;
            for (j = 0; j < copy1.length && !found; ++j) {
                if (copy1[j] != value) continue;
                found = true;
                this.ranks1[i] = j + 1;
                copy1[j] = DELETED;
            }
        }
        for (i = 0; i < this.sample2.length; ++i) {
            value = this.sample2[i];
            found = false;
            for (j = 0; j < copy2.length && !found; ++j) {
                if (copy2[j] != value) continue;
                found = true;
                this.ranks2[i] = j + 1;
                copy2[j] = DELETED;
            }
        }
    }

    public double getT() {
        return this.T;
    }

    public double getZ() {
        return this.Z;
    }

    public double getExactPValue() {
        return this.exactPValue;
    }

    public double getPositiveDependencePvalue() {
        return this.positiveDependencePvalue;
    }

    public double getNegativeDependencePvalue() {
        return this.negativeDependencePvalue;
    }

    public double getNoDependencePvalue() {
        return this.noDependencePvalue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n*************\n";
        report = report + "Kendall Test\n";
        report = report + "*************\n\n";
        report = report + "T statistic (Kendall's tau): " + this.nf6.format(this.T) + "\n";
        if (this.n > 2.0 && this.n < 11.0 && this.exactPValue > -1.0) {
            report = report + "Exact P-Value: " + this.nf6.format(this.exactPValue) + "\n";
        } else if (this.n > 10.0 && this.n < 31.0) {
            report = report + "Exact P-Value: <= " + this.nf6.format(this.exactPValue) + "\n";
        }
        report = report + "\nAsymptotic P-Values\n\n";
        report = report + "Z statistic: " + this.nf6.format(this.Z) + "\n";
        report = report + "Positive dependence (Right tail): " + this.nf6.format(this.positiveDependencePvalue) + "\n";
        report = report + "Negative dependence (Left Tail): " + this.nf6.format(this.negativeDependencePvalue) + "\n";
        report = report + "No dependence (Double tail): " + this.nf6.format(this.noDependencePvalue) + "\n\n";
        report = report + "Ranks computed:\n\n";
        report = report + "S1 \t S2\n\n";
        for (int i = 0; i < this.ranks1.length; ++i) {
            report = report + this.ranks1[i] + " \t " + this.ranks2[i] + "\n";
        }
        report = report + "\n";
        return report;
    }
}

