/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import java.io.IOException;
import javanpst.data.distributions.incompleteTable.Incomplete3KeyTable;
import javanpst.data.readers.distributionReaders.WilcoxonRankSumReaderFormat;
import javanpst.distributions.tests.TestDistribution;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WilcoxonRankSumDistribution
extends TestDistribution {
    private static Incomplete3KeyTable table;
    private int[][] maximum = new int[][]{{1, 2, 2, 3, 3, 4, 4, 5, 5, 6}, {0, 5, 6, 7, 8, 9, 10, 11, 12, 13}, {0, 0, 10, 12, 13, 15, 16, 18, 19, 21}, {0, 0, 0, 18, 20, 22, 24, 26, 28, 30}, {0, 0, 0, 0, 27, 30, 32, 35, 37, 40}, {0, 0, 0, 0, 0, 39, 42, 45, 48, 51}, {0, 0, 0, 0, 0, 0, 52, 56, 59, 63}, {0, 0, 0, 0, 0, 0, 0, 68, 72, 76}, {0, 0, 0, 0, 0, 0, 0, 0, 85, 90}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 105}};

    private WilcoxonRankSumDistribution() {
        this.initialize();
    }

    public static WilcoxonRankSumDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        table = new Incomplete3KeyTable(11, 11, 106);
        this.loadFiles();
    }

    @Override
    protected void loadFiles() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/Wilcoxon/WilcoxonRanksSumTable.xml"), (DefaultHandler)new WilcoxonRankSumReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }

    public static Incomplete3KeyTable getTable() {
        return table;
    }

    public double computeLeftProbability(int n, int m, int R) {
        if (n > 10 || m > 10 || R > 105) {
            return -1.0;
        }
        return table.get(n, m, R);
    }

    public double computeRightProbability(int n, int m, int R) {
        this.initialize();
        if (n > 10 || m > 10 || R > 105) {
            return -1.0;
        }
        int max = this.maximum[n - 1][m - 1];
        if (R <= max) {
            return -1.0;
        }
        int trueR = max % 2 == 0 ? 2 * max - R : 2 * max - (R - 1);
        return table.get(n, m, trueR);
    }

    public int findCriticalValue(int n, int m, double alpha) {
        int minimun = 0;
        double value = 0.0;
        int rank = -1;
        alpha /= 2.0;
        for (int i = 1; i <= m; ++i) {
            minimun += i;
        }
        while (value < alpha) {
            value = table.get(m, n, minimun);
            ++minimun;
            ++rank;
        }
        return rank;
    }

    public double inverseFindCriticalValue(int n, int m, int u) {
        int minimun = 0;
        double value = 0.0;
        for (int i = 1; i <= m; ++i) {
            minimun += i;
        }
        value = table.get(m, n, minimun + u - 1);
        return value *= 2.0;
    }

    private static class SingletonHolder {
        public static final WilcoxonRankSumDistribution distribution = new WilcoxonRankSumDistribution();

        private SingletonHolder() {
        }
    }
}

