/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import java.io.IOException;
import javanpst.data.distributions.incompleteTable.Incomplete2KeyTable;
import javanpst.data.readers.distributionReaders.NMDistributionReaderFormat;
import javanpst.distributions.tests.TestDistribution;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NMDistribution
extends TestDistribution {
    private static Incomplete2KeyTable leftTable;
    private static Incomplete2KeyTable rightTable;
    private static boolean approximate;

    private NMDistribution() {
        this.initialize();
    }

    public static NMDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        leftTable = new Incomplete2KeyTable(11, 285);
        rightTable = new Incomplete2KeyTable(11, 285);
        this.loadFiles();
    }

    @Override
    protected void loadFiles() {
        SAXParser sp;
        SAXParserFactory spf;
        try {
            spf = SAXParserFactory.newInstance();
            sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/RanksVonNeumann/NMRanksLeft.xml"), (DefaultHandler)new NMDistributionReaderFormat(0));
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
        try {
            spf = SAXParserFactory.newInstance();
            sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/RanksVonNeumann/NMRanksRight.xml"), (DefaultHandler)new NMDistributionReaderFormat(1));
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }

    public static Incomplete2KeyTable getTableLeft() {
        return leftTable;
    }

    public static Incomplete2KeyTable getTableRight() {
        return rightTable;
    }

    public double computeLeftProbability(int n, double realNM) {
        int NM = (int)Math.ceil(realNM);
        double prob = leftTable.get(n, NM);
        if (prob != -1.0) {
            approximate = false;
            return prob;
        }
        for (int i = NM + 1; i < 285 && prob == -1.0; ++i) {
            prob = leftTable.get(n, i);
        }
        if (prob == -1.0) {
            approximate = true;
            return 1.0;
        }
        approximate = true;
        return prob;
    }

    public double computeRightProbability(int n, double realNM) {
        int NM = (int)Math.floor(realNM);
        double prob = rightTable.get(n, NM);
        if (prob != -1.0) {
            approximate = false;
            return prob;
        }
        for (int i = NM - 1; i > 0 && prob == -1.0; --i) {
            prob = rightTable.get(n, i);
        }
        if (prob == -1.0) {
            approximate = true;
            return 1.0;
        }
        approximate = true;
        return prob;
    }

    public boolean isApproximate() {
        return approximate;
    }

    private static class SingletonHolder {
        public static final NMDistribution distribution = new NMDistribution();

        private SingletonHolder() {
        }
    }
}

