/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.common.discrete;

import javanpst.distributions.common.Distribution;

public final class GeometricDistribution
implements Distribution {
    private double p;

    public GeometricDistribution() {
        this.p = 0.0;
    }

    public GeometricDistribution(double p) {
        this.p = p;
    }

    public GeometricDistribution(GeometricDistribution old) {
        this(old.getP());
    }

    public void setP(double value) {
        if (value >= 0.0 && value <= 1.0) {
            this.p = value;
        }
    }

    public double getP() {
        return this.p;
    }

    @Override
    public double computeProbability(double value) {
        int x = (int)Math.floor(value);
        double prob = x < 1 ? 0.0 : Math.pow(1.0 - this.p, (double)x - 1.0) * this.p;
        return prob;
    }

    @Override
    public double computeCumulativeProbability(double value) {
        double prob = 0.0;
        int x = (int)Math.floor(value);
        prob = x < 1 ? 0.0 : 1.0 - Math.pow(this.p, (double)x + 1.0);
        return prob;
    }

    public String toString() {
        String text = "";
        text = text + "Geometric distribution. Parameters P:" + this.p;
        return text;
    }
}

