/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.common.continuous;

import javanpst.distributions.common.Distribution;

public class LaplaceDistribution
implements Distribution {
    private double mean;
    private double scale;

    public LaplaceDistribution() {
        this.mean = 0.0;
        this.scale = 1.0;
    }

    public LaplaceDistribution(double mean, double scale) {
        if (scale > 0.0) {
            this.mean = mean;
            this.scale = scale;
        }
    }

    public LaplaceDistribution(LaplaceDistribution old) {
        this(old.getMean(), old.getScale());
    }

    public void setMean(double value) {
        this.mean = value;
    }

    public void setScale(double value) {
        if (value > 0.0) {
            this.scale = value;
        }
    }

    public double getMean() {
        return this.mean;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double computeProbability(double x) {
        double value = Math.pow(Math.E, -Math.abs(x - this.mean) / this.scale);
        return value /= 2.0 * this.scale;
    }

    @Override
    public double computeCumulativeProbability(double x) {
        double prob = x < this.mean ? 0.5 * Math.exp((x - this.mean) / this.scale) : 0.5 * (2.0 - Math.exp((this.mean - x) / this.scale));
        return prob;
    }

    public String toString() {
        String text = "";
        text = text + "Laplace distribution. Mean: " + this.mean + " Scale: " + this.scale;
        return text;
    }
}

