/*
 * Decompiled with CFR 0.152.
 */
package javanpst.data.structures.sequence;

import java.util.ArrayList;
import javanpst.data.readers.sequenceReaders.StringSequenceCSVReader;
import javanpst.data.readers.sequenceReaders.StringSequenceTXTReader;
import javanpst.data.readers.sequenceReaders.StringSequenceXMLReader;
import javanpst.data.structures.sequence.Sequence;
import javanpst.data.writers.sequenceWriters.SequenceCSVWriter;
import javanpst.data.writers.sequenceWriters.SequenceTXTWriter;
import javanpst.data.writers.sequenceWriters.SequenceXMLWriter;

public class StringSequence
extends Sequence {
    private ArrayList<String> body;

    public StringSequence() {
        this.body = new ArrayList();
    }

    public StringSequence(ArrayList<String> contents) {
        this.body = new ArrayList<String>(contents);
    }

    public StringSequence(String[] contents) {
        this.body = new ArrayList();
        for (int i = 0; i < contents.length; ++i) {
            this.body.add(contents[i]);
        }
    }

    public StringSequence(StringSequence copy) {
        this(copy.getSequence());
    }

    public ArrayList<String> getSequence() {
        return this.body;
    }

    @Override
    public void append(Object text) {
        this.body.add(text.toString());
    }

    @Override
    public void prepend(Object text) {
        this.body.add(0, text.toString());
    }

    public String get(int index) {
        if (index > -1 && index < this.body.size()) {
            return this.body.get(index);
        }
        return "";
    }

    @Override
    public int size() {
        return this.body.size();
    }

    @Override
    public void clear() {
        this.body.clear();
    }

    @Override
    public String toString() {
        String text = "";
        for (String s : this.body) {
            text = text + s + "*";
        }
        text = text.substring(0, text.length() - 1);
        return text;
    }

    public boolean isBinary() {
        int i;
        if (this.body.size() < 2) {
            return true;
        }
        String firstElement = this.body.get(0);
        String s = this.body.get(1);
        for (i = 2; firstElement.equals(s) && i < this.body.size(); ++i) {
            s = this.body.get(i);
        }
        if (i == this.body.size()) {
            return true;
        }
        String secondElement = this.body.get(--i);
        ++i;
        while (i < this.body.size()) {
            if (!this.body.get(i).equals(firstElement) && !this.body.get(i).equals(secondElement)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void readXML(String file) {
        StringSequenceXMLReader.readXMLSequence(file);
        this.body = StringSequenceXMLReader.getSequence();
    }

    @Override
    public void writeXML(String file) {
        SequenceXMLWriter.writeStringSequence(this.body, file);
    }

    @Override
    public void readCSV(String file) {
        StringSequenceCSVReader.readCSVSequence(file);
        this.body = StringSequenceCSVReader.getSequence();
    }

    @Override
    public void writeCSV(String file, boolean useComma) {
        SequenceCSVWriter.writeStringSequence(this.body, file, useComma);
    }

    @Override
    public void readTXT(String file) {
        StringSequenceTXTReader.readTXTSequence(file);
        this.body = StringSequenceTXTReader.getSequence();
    }

    @Override
    public void writeTXT(String file) {
        SequenceTXTWriter.writeStringSequence(this.body, file);
    }
}

