/*
 * Decompiled with CFR 0.152.
 */
package javanpst.data.readers.tabularDataReaders;

import javanpst.data.readers.tabularDataReaders.TabularDataXMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TabularDataXMLReaderFormat
extends DefaultHandler {
    String st;
    int counter;
    int rowCount;
    double[] array;
    int rows;
    int cols;

    public TabularDataXMLReaderFormat() {
        this.clearBuffer();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("tabular")) {
            this.cols = Integer.parseInt(attributes.getValue("columns"));
            this.rows = Integer.parseInt(attributes.getValue("rows"));
            TabularDataXMLReader.generateTable(this.rows, this.cols);
            this.rowCount = 0;
        }
        if (qName.equals("row")) {
            this.array = new double[this.cols];
            this.counter = 0;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.st = new String(buf, offset, len);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("element")) {
            this.addElement();
        }
        if (qName.equals("row")) {
            this.addRow();
        }
    }

    private void clearBuffer() {
        TabularDataXMLReader.clear();
    }

    private void addElement() {
        if (this.st.equals("NULL")) {
            TabularDataXMLReader.setNull(this.rowCount, this.counter);
            this.array[this.counter] = Double.MIN_VALUE;
        } else {
            this.array[this.counter] = Double.parseDouble(this.st);
        }
        ++this.counter;
    }

    private void addRow() {
        TabularDataXMLReader.addRow(this.rowCount, this.array);
        ++this.rowCount;
    }
}

