/*
 * Decompiled with CFR 0.152.
 */
package javanpst.data.readers.tabularDataReaders;

import java.io.IOException;
import javanpst.data.readers.tabularDataReaders.TabularDataXMLReaderFormat;
import javanpst.data.structures.dataTable.DataTable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TabularDataXMLReader {
    private static DataTable table;

    static void generateTable(int rows, int cols) {
        table = new DataTable();
        table.setDimensions(rows, cols);
    }

    public static DataTable getTable() {
        DataTable tab = DataTable.newInstance(table);
        return tab;
    }

    static void clear() {
        table.clear();
    }

    static void addRow(int row, double[] array) {
        table.setRow(row, array);
    }

    static void setNull(int row, int col) {
        table.setNull(row, col);
    }

    public static void readXMLTabularData(String file) {
        table = new DataTable();
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(file, (DefaultHandler)new TabularDataXMLReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }
}

