/*
 * Decompiled with CFR 0.152.
 */
package com.aurigalogic.javadoc2help.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class Util {
    private static final String RESOURCE_DIR = "/com/aurigalogic/javadoc2help/resources/";
    private static final String XSL_DIR = "/com/aurigalogic/javadoc2help/xsl/";

    private Util() {
    }

    public static void copyFiles(String srcDir, String destDir) throws Exception {
        File src = new File(srcDir);
        File[] files = src.listFiles();
        File dest = new File(destDir);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) {
                Util.copyFile(files[i], dest);
                continue;
            }
            File newDir = new File(destDir, files[i].getName());
            Util.copyFiles(files[i].getPath(), newDir.getPath());
        }
    }

    public static void copyResources(String srcDir, String destDir) throws Exception {
        String resourcePath = RESOURCE_DIR + srcDir;
        if (!resourcePath.endsWith(File.separator)) {
            resourcePath = resourcePath + "/";
        }
        String jarFilePath = Util.class.getResource(RESOURCE_DIR).getFile();
        jarFilePath = jarFilePath.substring(5, jarFilePath.indexOf("!"));
        JarFile jarFile = new JarFile(jarFilePath);
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String name = "/" + entry.getName();
            if (!name.startsWith(resourcePath) || entry.isDirectory()) continue;
            URL resourceUrl = Util.class.getResource(name);
            String fileName = name.substring(resourcePath.length(), name.length());
            InputStream in = resourceUrl.openStream();
            File outFile = new File(destDir, fileName);
            FileOutputStream out = new FileOutputStream(outFile);
            Util.copyStream(in, out);
        }
    }

    public static InputStream getXSLResource(String path) throws Exception {
        return Util.class.getResourceAsStream(XSL_DIR + path);
    }

    private static void copyFile(File sourceFile, File destDir) throws IOException {
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File destFile = new File(destDir, sourceFile.getName());
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        Util.copyStream(in, out);
    }

    public static void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static InputStream makeStream(StringBuffer buffer) throws Exception {
        String packageTreeStr = new String(buffer);
        return new ByteArrayInputStream(packageTreeStr.getBytes());
    }

    public static ArrayList getHtmlFileList(String dir) throws Exception {
        ArrayList list = new ArrayList();
        File file = new File(dir);
        Util.traverseFolder(file, list);
        return list;
    }

    public static String readFile(String path) throws Exception {
        String line;
        FileReader fr = new FileReader(path);
        BufferedReader br = new BufferedReader(fr);
        StringBuffer content = new StringBuffer();
        while ((line = br.readLine()) != null) {
            content = content.append(line);
            content = content.append("\n");
        }
        br.close();
        fr.close();
        return content.toString();
    }

    public static void writeFile(String path, String content) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        FileOutputStream os = new FileOutputStream(path);
        Util.copyStream(is, os);
    }

    private static void traverseFolder(File folder, ArrayList list) {
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                Util.traverseFolder(file, list);
                continue;
            }
            if (!file.getName().endsWith(".html")) continue;
            list.add(file.getAbsolutePath());
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
        in.close();
        in = null;
        out = null;
    }
}

