/*
 * Decompiled with CFR 0.152.
 */
package com.aurigalogic.javadoc2help.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class JHelpViewer
extends JDialog {
    private JFrame win;

    private static void printUsage() {
        System.out.println("\nUsage: java " + JHelpViewer.class.getName() + "resourcepath helpsetname");
    }

    public JHelpViewer(JFrame win, URL urlString) {
        this.win = win;
        this.setDefaultCloseOperation(2);
        this.setTitle("DataMelt API");
        this.setModal(false);
        this.setResizable(true);
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Container contentPane = this.getContentPane();
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            HelpSet hs = new HelpSet(cl, urlString);
            JHelp jhelp = new JHelp(hs);
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)jhelp);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize(screenSize);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JHelpViewer.this.dispose();
                }
            });
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return;
        }
        this.pack();
        this.setVisible();
    }

    public void setVisible() {
        Dimension dim = this.win.getSize();
        int w = dim.width;
        int h = dim.height;
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(Math.min((int)(0.75 * (double)w), res.width), Math.min((int)(0.9 * (double)h), res.height));
        this.setSize(size);
        JHelpViewer.centreWithin(this.win, this);
        this.setVisible(true);
    }

    public static void centreWithin(Component parent, Component child) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension win = child.getSize();
        Point p = JHelpViewer.centreWithinRec(parent.getBounds(), win);
        int diff = screen.width - p.x - win.width;
        if (diff < 0) {
            p.x += diff;
        }
        if ((diff = screen.height - p.y - win.height) < 0) {
            p.y += diff;
        }
        p.x = Math.max(0, p.x);
        p.y = Math.max(0, p.y);
        child.setLocation(p);
    }

    public static Point centreWithinRec(Rectangle rec, Dimension dim) {
        Point pos = new Point();
        pos.x = rec.x + (rec.width - dim.width >> 1);
        pos.y = rec.y + (rec.height - dim.height >> 1);
        return pos;
    }
}

