/*
 * Decompiled with CFR 0.152.
 */
package hephysics.vec;

import hephysics.vec.Hep3Vector;
import java.io.Serializable;

public class SpacePoint
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Representation _representation;
    private double _x;
    private double _y;
    private double _z;
    private double _xy;
    private double _xyz;
    private double _phi;
    private double _theta;

    public double[] v() {
        switch (this._representation) {
            case Cartesian: {
                return new double[]{this._x, this._y, this._z};
            }
            case Spherical: {
                return new double[]{this._xyz, this._phi, this._theta};
            }
            case Cylindrical: {
                return new double[]{this._xy, this._phi, this._z};
            }
        }
        return new double[3];
    }

    private void cartesianToCylindricalR() {
        this._xy = Math.sqrt(this._x * this._x + this._y * this._y);
    }

    private void cartesianToPhi() {
        this._phi = Math.atan2(this._y, this._x);
    }

    private void cartesianToTheta() {
        if (Double.isNaN(this._xy)) {
            this.cartesianToCylindricalR();
        }
        this._theta = Math.atan2(this._xy, this._z);
    }

    public double magnitude() {
        return this._xyz;
    }

    public double magnitudeSquared() {
        return this._xyz * this._xyz;
    }

    public SpacePoint() {
        this._z = 0.0;
        this._y = 0.0;
        this._x = 0.0;
        this._xyz = 0.0;
        this._xy = 0.0;
        this._theta = 0.0;
        this._phi = 0.0;
    }

    public SpacePoint(SpacePoint spt) {
        this._representation = spt._representation;
        this._x = spt.x();
        this._y = spt.y();
        this._z = spt.z();
        this._xy = spt.rxy();
        this._xyz = spt.rxyz();
        this._phi = spt.phi();
        this._theta = spt.theta();
    }

    public SpacePoint(Hep3Vector vec) {
        this._representation = Representation.Cartesian;
        this._x = vec.x();
        this._y = vec.y();
        this._z = vec.z();
        this._xyz = Math.sqrt(this._x * this._x + this._y * this._y + this._z * this._z);
        this._theta = Double.NaN;
        this._phi = Double.NaN;
        this._xy = Double.NaN;
    }

    private void cylindricalToCartesianX() {
        this._x = this._xy * Math.cos(this._phi);
    }

    private void sphericalToCartesianX() {
        this._x = this._xyz * Math.cos(this._phi) * Math.sin(this._theta);
    }

    private void sphericalToCartesianY() {
        this._y = this._xyz * Math.sin(this._phi) * Math.sin(this._theta);
    }

    private void sphericalToCartesianZ() {
        this._z = this._xyz * Math.cos(this._theta);
    }

    public double x() {
        if (Double.isNaN(this._x)) {
            switch (this._representation) {
                case Spherical: {
                    this.sphericalToCartesianX();
                    break;
                }
                case Cylindrical: {
                    this.cylindricalToCartesianX();
                }
            }
        }
        return this._x;
    }

    private void cylindricalToCartesianY() {
        this._y = this._xy * Math.sin(this._phi);
    }

    public double y() {
        if (Double.isNaN(this._y)) {
            switch (this._representation) {
                case Spherical: {
                    this.sphericalToCartesianY();
                    break;
                }
                case Cylindrical: {
                    this.cylindricalToCartesianY();
                }
            }
        }
        return this._y;
    }

    public double z() {
        if (Double.isNaN(this._z)) {
            this.sphericalToCartesianZ();
        }
        return this._z;
    }

    private void sphericalToCylindricalR() {
        this._xy = this._xyz * Math.sin(this._theta);
    }

    public double rxy() {
        if (Double.isNaN(this._xy)) {
            switch (this._representation) {
                case Spherical: {
                    this.sphericalToCylindricalR();
                    break;
                }
                case Cartesian: {
                    this.cartesianToCylindricalR();
                }
            }
        }
        return this._xy;
    }

    public double phi() {
        if (Double.isNaN(this._phi)) {
            this.cartesianToPhi();
        }
        return this._phi;
    }

    public double rxyz() {
        return this._xyz;
    }

    public double theta() {
        if (Double.isNaN(this._theta)) {
            switch (this._representation) {
                case Cartesian: {
                    this.cartesianToTheta();
                    break;
                }
                case Cylindrical: {
                    this.cylindricalToTheta();
                }
            }
        }
        return this._theta;
    }

    private void cylindricalToTheta() {
        this._theta = Math.atan2(this._xy, this._z);
    }

    public double cosPhi() {
        if (!Double.isNaN(this._x) && !Double.isNaN(this._xy) && this._xy != 0.0) {
            return this._x / this._xy;
        }
        if (Double.isNaN(this._phi)) {
            this.cartesianToPhi();
        }
        return Math.cos(this._phi);
    }

    public double sinPhi() {
        if (!Double.isNaN(this._y) && !Double.isNaN(this._xy) && this._xy != 0.0) {
            return this._y / this._xy;
        }
        if (Double.isNaN(this._phi)) {
            this.cartesianToPhi();
        }
        return Math.sin(this._phi);
    }

    public double sinTheta() {
        if (!Double.isNaN(this._xy) && this._xyz != 0.0) {
            return this._xy / this._xyz;
        }
        if (Double.isNaN(this._theta)) {
            switch (this._representation) {
                case Cartesian: {
                    this.cartesianToTheta();
                    break;
                }
                case Cylindrical: {
                    this.cylindricalToTheta();
                }
            }
        }
        return Math.sin(this._theta);
    }

    public double cosTheta() {
        if (!Double.isNaN(this._z) && this._xyz != 0.0) {
            return this._z / this._xyz;
        }
        if (Double.isNaN(this._theta)) {
            switch (this._representation) {
                case Cartesian: {
                    this.cartesianToTheta();
                    break;
                }
                case Cylindrical: {
                    this.cylindricalToTheta();
                }
            }
        }
        return Math.cos(this._theta);
    }

    public String toString() {
        return (Object)((Object)this._representation) + " SpacePoint: \n    x: " + this.x() + "\n    y: " + this.y() + "\n    z: " + this.z() + "\n  rxy: " + this.rxy() + "\n rxyz: " + this.rxyz() + "\n  phi: " + this.phi() + "\ntheta: " + this.theta() + "\n";
    }

    public boolean equals(SpacePoint spt, double precision) {
        return Math.abs(this.x() - spt.x()) < precision && Math.abs(this.y() - spt.y()) < precision && Math.abs(this.z() - spt.z()) < precision;
    }

    public boolean equals(Hep3Vector spt, double precision) {
        return Math.abs(this.x() - spt.x()) < precision && Math.abs(this.y() - spt.y()) < precision && Math.abs(this.z() - spt.z()) < precision;
    }

    public boolean equals(SpacePoint x) {
        return this.equals(x, 1.0E-14);
    }

    public boolean notEquals(SpacePoint spt) {
        return !this.equals(spt);
    }

    public static double distance(SpacePoint spt1, SpacePoint spt2) {
        double dx = spt2.x() - spt1.x();
        double dy = spt2.y() - spt1.y();
        double dz = spt2.z() - spt1.z();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }

    public double[] getCartesianArray() {
        return new double[]{this._x, this._y, this._z};
    }

    public Representation getRepresentation() {
        return this._representation;
    }

    public static enum Representation {
        Cartesian,
        Cylindrical,
        Spherical;

    }
}

