/*
 * Decompiled with CFR 0.152.
 */
package hephysics.vec;

import hephysics.matrix.BasicMatrix;
import hephysics.matrix.Matrix;
import hephysics.matrix.MatrixOp;
import hephysics.vec.VecOp;

public class Hep3Matrix
extends BasicMatrix {
    private static final long serialVersionUID = 1L;

    public Hep3Matrix(int nRows, int nCols) {
        super(nRows, nCols);
    }

    public Hep3Matrix(double[][] data) {
        super(data);
    }

    public Hep3Matrix() {
        super(3, 3);
    }

    public Hep3Matrix(double e11, double e12, double e13, double e21, double e22, double e23, double e31, double e32, double e33) {
        super(e11, e12, e13, e21, e22, e23, e31, e32, e33);
    }

    public Hep3Matrix(Matrix m) throws MatrixOp.InvalidMatrixException {
        super(m);
        if (m.getNColumns() != 3 || m.getNRows() != 3) {
            throw new MatrixOp.InvalidMatrixException("Not 3x3 matrix");
        }
        this.m_dmat = new double[3][3];
        this.m_dmat[0][0] = m.e(0, 0);
        this.m_dmat[0][1] = m.e(0, 1);
        this.m_dmat[0][2] = m.e(0, 2);
        this.m_dmat[1][0] = m.e(1, 0);
        this.m_dmat[1][1] = m.e(1, 1);
        this.m_dmat[1][2] = m.e(1, 2);
        this.m_dmat[2][0] = m.e(2, 0);
        this.m_dmat[2][1] = m.e(2, 1);
        this.m_dmat[2][2] = m.e(2, 2);
    }

    @Override
    public double e(int row, int column) {
        return this.m_dmat[row][column];
    }

    @Override
    public double det() {
        double cofact1 = this.m_dmat[1][1] * this.m_dmat[2][2] - this.m_dmat[1][2] * this.m_dmat[2][1];
        double cofact2 = this.m_dmat[0][1] * this.m_dmat[2][2] - this.m_dmat[0][2] * this.m_dmat[2][1];
        double cofact3 = this.m_dmat[0][1] * this.m_dmat[1][2] - this.m_dmat[0][2] * this.m_dmat[1][1];
        return this.m_dmat[0][0] * cofact1 - this.m_dmat[1][0] * cofact2 + this.m_dmat[2][0] * cofact3;
    }

    public double trace() {
        return this.m_dmat[0][0] + this.m_dmat[1][1] + this.m_dmat[2][2];
    }

    @Override
    public void setElement(int row, int column, double value) {
        this.m_dmat[row][column] = value;
    }

    public void setPassiveEuler(double phi, double theta, double psi) {
        double cth = Math.cos(theta);
        double sth = Math.sin(theta);
        double cphi = Math.cos(phi);
        double sphi = Math.sin(phi);
        double cpsi = Math.cos(psi);
        double spsi = Math.sin(psi);
        this.m_dmat[0][0] = cpsi * cphi - cth * sphi * spsi;
        this.m_dmat[0][1] = cpsi * sphi + cth * cphi * spsi;
        this.m_dmat[0][2] = spsi * sth;
        this.m_dmat[1][0] = -spsi * cphi - cth * sphi * cpsi;
        this.m_dmat[1][1] = -spsi * sphi + cth * cphi * cpsi;
        this.m_dmat[1][2] = cpsi * sth;
        this.m_dmat[2][0] = sth * sphi;
        this.m_dmat[2][1] = -sth * cphi;
        this.m_dmat[2][2] = cth;
    }

    public void setActiveEuler(double phi, double theta, double psi) {
        double cth = Math.cos(theta);
        double sth = Math.sin(theta);
        double cphi = Math.cos(phi);
        double sphi = Math.sin(phi);
        double cpsi = Math.cos(psi);
        double spsi = Math.sin(psi);
        this.m_dmat[0][0] = cpsi * cphi - cth * sphi * spsi;
        this.m_dmat[1][0] = cpsi * sphi + cth * cphi * spsi;
        this.m_dmat[2][0] = spsi * sth;
        this.m_dmat[0][1] = -spsi * cphi - cth * sphi * cpsi;
        this.m_dmat[1][1] = -spsi * sphi + cth * cphi * cpsi;
        this.m_dmat[2][1] = cpsi * sth;
        this.m_dmat[0][2] = sth * sphi;
        this.m_dmat[1][2] = -sth * cphi;
        this.m_dmat[2][2] = cth;
    }

    public static Hep3Matrix identity() {
        Hep3Matrix result = new Hep3Matrix();
        result.m_dmat[0][0] = 1.0;
        result.m_dmat[1][1] = 1.0;
        result.m_dmat[2][2] = 1.0;
        return result;
    }

    @Override
    public String toString() {
        return VecOp.toString(this);
    }

    @Override
    public int getNRows() {
        return 3;
    }

    @Override
    public int getNColumns() {
        return 3;
    }

    @Override
    public void invert() throws MatrixOp.IndeterminateMatrixException {
        MatrixOp.inverse(this, this);
    }

    @Override
    public void transpose() {
        double t = this.m_dmat[0][1];
        this.m_dmat[0][1] = this.m_dmat[1][0];
        this.m_dmat[1][0] = t;
        t = this.m_dmat[0][2];
        this.m_dmat[0][2] = this.m_dmat[2][0];
        this.m_dmat[2][0] = t;
        t = this.m_dmat[1][2];
        this.m_dmat[1][2] = this.m_dmat[2][1];
        this.m_dmat[2][1] = t;
    }

    public static Hep3Matrix mult(Hep3Matrix m1, Hep3Matrix m2) {
        double e0 = m1.e(0, 0) * m2.e(0, 0) + m1.e(0, 1) * m2.e(1, 0) + m1.e(0, 2) * m2.e(2, 0);
        double e1 = m1.e(0, 0) * m2.e(0, 1) + m1.e(0, 1) * m2.e(1, 1) + m1.e(0, 2) * m2.e(2, 1);
        double e2 = m1.e(0, 0) * m2.e(0, 2) + m1.e(0, 1) * m2.e(1, 2) + m1.e(0, 2) * m2.e(2, 2);
        double e3 = m1.e(1, 0) * m2.e(0, 0) + m1.e(1, 1) * m2.e(1, 0) + m1.e(1, 2) * m2.e(2, 0);
        double e4 = m1.e(1, 0) * m2.e(0, 1) + m1.e(1, 1) * m2.e(1, 1) + m1.e(1, 2) * m2.e(2, 1);
        double e5 = m1.e(1, 0) * m2.e(0, 2) + m1.e(1, 1) * m2.e(1, 2) + m1.e(1, 2) * m2.e(2, 2);
        double e6 = m1.e(2, 0) * m2.e(0, 0) + m1.e(2, 1) * m2.e(1, 0) + m1.e(2, 2) * m2.e(2, 0);
        double e7 = m1.e(2, 0) * m2.e(0, 1) + m1.e(2, 1) * m2.e(1, 1) + m1.e(2, 2) * m2.e(2, 1);
        double e8 = m1.e(2, 0) * m2.e(0, 2) + m1.e(2, 1) * m2.e(1, 2) + m1.e(2, 2) * m2.e(2, 2);
        return new Hep3Matrix(e0, e1, e2, e3, e4, e5, e6, e7, e8);
    }
}

