/*
 * Decompiled with CFR 0.152.
 */
package hephysics.particle;

import hephysics.vec.Hep3Vector;
import hephysics.vec.HepLorentzVector;
import java.io.Serializable;
import java.util.Formatter;
import java.util.Random;
import jhplot.gui.HelpBrowser;

public class LParticle
extends HepLorentzVector
implements Comparable<LParticle>,
Serializable {
    static final long serialVersionUID = -6544699016896436061L;
    protected double mass;
    protected String name;
    protected LParticle parent;
    protected double charge;

    public LParticle() {
        super(0.0, 0.0, 0.0, 0.0);
        this.name = "";
        this.mass = 0.0;
        this.charge = 0.0;
        this.energy = 0.0;
    }

    public LParticle(String name) {
        super(0.0, 0.0, 0.0, 0.0);
        this.name = name;
        this.mass = 0.0;
        this.charge = 0.0;
        this.energy = 0.0;
    }

    public LParticle(String name, double mass) {
        super(0.0, 0.0, 0.0, 0.0);
        this.name = name;
        this.mass = mass;
        this.charge = 0.0;
        this.energy = 0.0;
    }

    public LParticle(double px, double py, double pz) {
        super(0.0, px, py, pz);
        this.mass = 0.0;
        this.charge = 0.0;
        this.energy = 0.0;
    }

    public void setPxPyPz(double px, double py, double pz) {
        this.setPx(px);
        this.setPy(py);
        this.setPz(pz);
    }

    public void setPxPyPzE(double px, double py, double pz, double e) {
        this.setPx(px);
        this.setPy(py);
        this.setPz(pz);
        this.setE(e);
    }

    public void setXYZT(double x, double y, double z, double t) {
        this.setPx(x);
        this.setPy(y);
        this.setPz(z);
        this.setT(t);
    }

    public LParticle(double px, double py, double pz, double energy, double mass) {
        super(px, py, pz, energy);
        this.mass = mass;
        this.charge = 0.0;
    }

    public LParticle(double px, double py, double pz, double energy) {
        super(px, py, pz, energy);
        this.mass = 0.0;
        this.charge = 0.0;
    }

    public LParticle(String name, double px, double py, double pz, double energy, double mass) {
        super(px, py, pz, energy);
        this.name = name;
        this.mass = mass;
        this.charge = 0.0;
    }

    public void setParent(LParticle parent) {
        this.parent = parent;
    }

    public void scalePxPyPzE(double scale) {
        this.setPx(this.px() * scale);
        this.setPy(this.py() * scale);
        this.setPz(this.pz() * scale);
        this.setE(this.e() * scale);
    }

    public void scaleXYZT(double scale) {
        this.setX(this.x() * scale);
        this.setY(this.y() * scale);
        this.setZ(this.z() * scale);
        this.setT(this.t() * scale);
    }

    public void dividePxPyPzE(double scale) {
        this.setPx(this.px() / scale);
        this.setPy(this.py() / scale);
        this.setPz(this.pz() / scale);
        this.setE(this.e() / scale);
    }

    public LParticle getParent() {
        return this.parent;
    }

    public void add(LParticle another) {
        this.setPx(this.v.x() + another.v3().x());
        this.setPy(this.v.y() + another.v3().y());
        this.setPz(this.v.z() + another.v3().z());
        this.energy += another.getE();
        this.t += another.getT();
        this.name = this.name + "+" + another.getName();
        this.charge += another.getCharge();
    }

    public double getMass() {
        return this.mass;
    }

    public double mass() {
        return this.mass;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Hep3Vector getV3() {
        return this.getV3();
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    @Override
    public int hashCode() {
        return this.hashCode() + (int)Double.doubleToRawLongBits(this.energy);
    }

    public void setThetaPhiP(double theta, double phi, double P) {
        double e = Math.sqrt(P * P + this.getMass() * this.getMass());
        double pX = P * Math.sin(theta) * Math.cos(phi);
        double pY = P * Math.sin(theta) * Math.sin(phi);
        double pZ = P * Math.cos(theta);
        this.setV3(pX, pY, pZ);
        this.setE(e);
    }

    public void setPtEtaPhiE(double pt, double eta, double phi, double e) {
        double apt = Math.abs(pt);
        double px = apt * Math.cos(phi);
        double py = apt * Math.sin(phi);
        double pz = apt * Math.sinh(eta);
        this.setPxPyPzE(px, py, pz, e);
    }

    public void setPtEtaPhiM(double pt, double eta, double phi, double m) {
        double apt = Math.abs(pt);
        double px = apt * Math.cos(phi);
        double py = apt * Math.sin(phi);
        double pz = apt * Math.sinh(eta);
        this.mass = m;
        double ee = px * px + py * py + pz * pz - m * m;
        ee = ee < 0.0 ? 0.0 : Math.sqrt(ee);
        this.setPxPyPzE(px, py, pz, ee);
    }

    public double abs() {
        return Math.sqrt(this.skp(this));
    }

    public void setCharge(double charge) {
        this.charge = charge;
    }

    public double getCharge() {
        return this.charge;
    }

    public double angle(LParticle momentum) {
        if (this.abs() <= 0.0 || momentum.abs() <= 0.0) {
            return 0.0;
        }
        return Math.acos(this.skp(momentum) / this.abs() / momentum.abs());
    }

    public double calcMass() {
        double s = this.energy * this.energy - this.skp(this);
        if (s > 0.0) {
            return Math.sqrt(s);
        }
        return -1.0 * Math.sqrt(-1.0 * s);
    }

    public void twoBodyDecay(LParticle prod1, LParticle prod2, boolean randomRotate) {
        double m2;
        double m = this.mass;
        double m1 = prod1.getMass();
        if (m < m1 + (m2 = prod2.getMass())) {
            System.out.println("twoBodyDecay  parent mass is less than sum of products.");
            prod1.setV3(0.0, 0.0, 0.0);
            prod2.setV3(0.0, 0.0, 0.0);
            return;
        }
        double e1 = (m * m + m1 * m1 - m2 * m2) / (2.0 * m);
        double e2 = (m * m - m1 * m1 + m2 * m2) / (2.0 * m);
        double P = Math.sqrt(e1 * e1 - m1 * m1);
        double ran1 = 0.0;
        double ran2 = 0.0;
        if (randomRotate) {
            Random r = new Random();
            ran1 = r.nextDouble();
            ran2 = r.nextDouble();
        }
        double theta = Math.acos(2.0 * ran1 - 1.0);
        double phi = Math.PI * 2 * ran2;
        double pX = P * Math.sin(theta) * Math.cos(phi);
        double pY = P * Math.sin(theta) * Math.sin(phi);
        double pZ = P * Math.cos(theta);
        prod1.setV3(pX, pY, pZ);
        prod1.setE(e1);
        prod2.setV3(-pX, -pY, -pZ);
        prod2.setE(e2);
    }

    public void boost(LParticle parent) {
        double betax = parent.v3().x() / parent.e();
        double betay = parent.v3().y() / parent.e();
        double betaz = parent.v3().z() / parent.e();
        double beta2 = betax * betax + betay * betay + betaz * betaz;
        double gamma = 1.0 / Math.sqrt(1.0 - beta2);
        double dot = betax * this.v.x() + betay * this.v.y() + betaz * this.v.z();
        double prod = gamma * (gamma * dot / (1.0 + gamma) + this.energy);
        double pX = this.v.x() + betax * prod;
        double pY = this.v.y() + betay * prod;
        double pZ = this.v.z() + betaz * prod;
        double e = gamma * (this.energy + dot);
        this.setV3(pX, pY, pZ);
        this.energy = e;
        this.parent = parent;
    }

    @Override
    public String toString() {
        Formatter formatter = new Formatter();
        formatter.format("M=%9.4g,E=%9.4g,T=%9.4g", this.mass, this.energy, this.t);
        String sname = String.format("%10s", this.name);
        return new String(sname + " " + this.v.toString() + ", " + formatter.out().toString());
    }

    @Override
    public LParticle copy() {
        LParticle tmp = new LParticle(this.getName(), this.pz(), this.pz(), this.pz(), this.e(), this.getMass());
        tmp.setParent(this.getParent());
        this.setT(this.t());
        this.setCharge(this.getCharge());
        return tmp;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    @Override
    public int compareTo(LParticle o) {
        int tmp = 0;
        if (this.perp2() < o.perp2()) {
            tmp = 1;
        }
        if (this.perp2() > o.perp2()) {
            tmp = -1;
        }
        return tmp;
    }
}

