/*
 * Decompiled with CFR 0.152.
 */
package hephysics.matrix;

import hephysics.matrix.Matrix;
import hephysics.matrix.MatrixOp;
import hephysics.matrix.MutableMatrix;
import java.io.Serializable;

public class SymmetricMatrix
implements MutableMatrix,
Serializable {
    static final long serialVersionUID = -7824887420997633477L;
    private final double[] values;
    private final int[] startIndex;
    private final int size;

    public SymmetricMatrix(int size) {
        this.size = size;
        this.startIndex = new int[size];
        int ii = 0;
        int i = 0;
        while (i < size) {
            this.startIndex[i] = ii;
            ii += ++i;
        }
        this.values = new double[ii];
    }

    public SymmetricMatrix(Matrix mIn) {
        this(mIn.getNRows());
        if (mIn instanceof SymmetricMatrix) {
            SymmetricMatrix m = (SymmetricMatrix)mIn;
            System.arraycopy(m.values, 0, this.values, 0, this.values.length);
        } else {
            int nRows = mIn.getNRows();
            if (nRows != mIn.getNColumns()) {
                throw new IllegalArgumentException("Input matrix is not square");
            }
            for (int i = 0; i < nRows; ++i) {
                for (int j = 0; j <= i; ++j) {
                    this.values[this.elementIndex((int)i, (int)j)] = mIn.e(i, j);
                }
            }
        }
    }

    public SymmetricMatrix(int size, double[] initialValues, boolean isLower) {
        this(size);
        if (this.values.length != initialValues.length) {
            throw new IllegalArgumentException("initialValues have invalid length");
        }
        this.copy(initialValues, this.values, !isLower);
    }

    public double[] asPackedArray(boolean isLower) {
        double[] result = new double[this.values.length];
        this.copy(this.values, result, !isLower);
        return result;
    }

    private void copy(double[] source, double[] dest, boolean flip) {
        if (flip) {
            int k = 0;
            for (int i = 0; i < this.size; ++i) {
                for (int j = i; j < this.size; ++j) {
                    dest[this.elementIndex((int)i, (int)j)] = source[k++];
                }
            }
        } else {
            System.arraycopy(source, 0, dest, 0, dest.length);
        }
    }

    @Override
    public int getNRows() {
        return this.size;
    }

    @Override
    public int getNColumns() {
        return this.size;
    }

    public double diagonal(int index) {
        return this.values[this.elementIndex(index, index)];
    }

    @Override
    public double e(int x, int y) {
        return this.values[this.elementIndex(x, y)];
    }

    @Override
    public void setElement(int x, int y, double value) {
        this.values[this.elementIndex((int)x, (int)y)] = value;
    }

    public void incrementElement(int x, int y, double value) {
        int n = this.elementIndex(x, y);
        this.values[n] = this.values[n] + value;
    }

    private int elementIndex(int x, int y) {
        return x >= y ? this.startIndex[x] + y : this.startIndex[y] + x;
    }

    public double det() {
        return MatrixOp.det(this);
    }

    public String toString() {
        return MatrixOp.toString(this);
    }

    @Override
    public void invert() throws MatrixOp.IndeterminateMatrixException {
        MatrixOp.inverse(this, this);
    }

    @Override
    public void transpose() {
    }
}

