/*
 * Decompiled with CFR 0.152.
 */
package hephysics.jet;

import hephysics.particle.LParticle;
import java.util.Random;

public class Main {
    public static void main(String[] args) {
        double P = 0.0;
        LParticle G = new LParticle("Graviton", 2000.0);
        LParticle top1 = new LParticle("top", 170.0);
        LParticle top2 = new LParticle("topBar", 170.0);
        LParticle W1 = new LParticle("W1", 80.0);
        LParticle W2 = new LParticle("W2", 80.0);
        LParticle b1 = new LParticle("b1", 50.0);
        LParticle b2 = new LParticle("b2", 50.0);
        LParticle q1 = new LParticle("q1", 0.004);
        LParticle q2 = new LParticle("q2", 0.004);
        LParticle q3 = new LParticle("q3", 0.004);
        LParticle q4 = new LParticle("q4", 0.004);
        System.out.println("Initial Graviton momenta:" + Double.toString(P));
        System.out.println("Initial parameters:");
        G.setV3(0.0, 0.0, P);
        G.print();
        top1.print();
        top2.print();
        W1.print();
        W2.print();
        b1.print();
        b2.print();
        Random r = new Random();
        for (int event = 0; event < 10; ++event) {
            System.out.println("Event=" + Integer.toString(event));
            G.twoBodyDecay(top1, top2, true);
            double ran1 = r.nextDouble();
            double ran2 = r.nextDouble();
            double theta = Math.acos(2.0 * ran1 - 1.0);
            double phi = Math.PI * 2 * ran2;
            G.setThetaPhiP(theta, phi, P);
            top1.boost(G);
            top2.boost(G);
            top1.twoBodyDecay(b1, W1, true);
            b1.boost(top1);
            W1.boost(top1);
            W1.twoBodyDecay(q1, q2, true);
            q1.boost(W1);
            q2.boost(W1);
            top2.twoBodyDecay(b2, W2, true);
            b2.boost(top2);
            W2.boost(top2);
            W2.twoBodyDecay(q3, q4, true);
            q3.boost(W2);
            q4.boost(W2);
            G.print();
            top1.print();
            top2.print();
            W1.print();
            W2.print();
            b1.print();
            b2.print();
            q1.print();
            q2.print();
            q3.print();
            q4.print();
            double deg = 57.29577951308232;
            System.out.println(top1.angle(W1) * deg);
            System.out.println(top1.angle(b1) * deg);
            System.out.println(top1.angle(q1) * deg);
            System.out.println(top1.angle(q2) * deg);
            System.out.println("Second decay");
            System.out.println(top2.angle(W2) * deg);
            System.out.println(top2.angle(b2) * deg);
            System.out.println(top2.angle(q3) * deg);
            System.out.println(top2.angle(q4) * deg);
            System.out.println("Checking-----");
            LParticle XX = new LParticle("", 0.0);
            XX.add(q1);
            XX.add(q2);
            XX.add(q3);
            XX.add(q4);
            XX.add(b1);
            XX.add(b2);
            System.out.println(XX.calcMass());
        }
    }
}

