/*
 * Decompiled with CFR 0.152.
 */
package hephysics.jet;

import hephysics.jet.ParticleF;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;

public class KTjet {
    private int recom = 1;
    private static float R;
    private static float R2;
    private int[] is_consider;
    private float[] ktdistance1;
    private float[][] ktdistance12;
    private ArrayList<ParticleF> jets;
    private static final float PI2 = (float)Math.PI * 2;
    private boolean debug = false;
    private double minpt = 0.0;
    private static int mode;
    private DecimalFormat formatter = new DecimalFormat("#.#####");

    public KTjet(double R, int recom, int mode, double minpt) {
        KTjet.R = (float)R;
        R2 = (float)(R * R);
        this.recom = recom;
        this.debug = false;
        this.minpt = minpt;
        KTjet.mode = mode;
        DecimalFormat formatter = new DecimalFormat("#0.00");
        String rs = formatter.format(KTjet.R);
        System.out.println("Initialization of Java jet algorithm. S.Chekanov (ANL)");
        System.out.println("Inclusive mode using the E-scheme recombination and R=" + rs);
        System.out.println("Distance is defined in pseudo-rapidity, phi, Et");
        if (mode == 1) {
            System.out.println("Longitudinally invariant kT algorithm");
        } else if (mode == 0) {
            System.out.println("Cambridge/Aachen algorithm");
        } else if (mode == -1) {
            System.out.println("Longitudinally invariant anti-kT algorithm");
        } else {
            System.out.println("Not correct mode:  Fallback to the inclusive kT algorithm using E-scheme and R=" + rs);
        }
    }

    public KTjet(double R, int recom, double minpt) {
        this(R, recom, 1, minpt);
    }

    public KTjet(double R, double minpt) {
        this(R, 1, 1, minpt);
    }

    public ArrayList<ParticleF> buildJets(ArrayList<ParticleF> list) {
        ParticleF p1;
        this.jets = new ArrayList();
        int size = list.size();
        long startTime = 0L;
        if (this.debug) {
            startTime = System.currentTimeMillis();
        }
        int j1 = -1;
        int j2 = -1;
        double min12 = Double.MAX_VALUE;
        this.ktdistance1 = new float[size];
        this.is_consider = new int[size];
        for (int m = 0; m < size; ++m) {
            this.is_consider[m] = 1;
            p1 = list.get(m);
            this.ktdistance1[m] = this.getKtDistance1(p1);
        }
        this.ktdistance12 = new float[size][size];
        for (int i = 0; i < size - 1; ++i) {
            p1 = list.get(i);
            for (int j = i + 1; j < size; ++j) {
                ParticleF p2 = list.get(j);
                this.ktdistance12[i][j] = this.getKtDistance12(p1, p2);
            }
        }
        if (this.debug) {
            long stopTime = System.currentTimeMillis();
            long runTime = stopTime - startTime;
            System.out.println("--->  Run time after creating initial pair distances (ms): " + runTime);
        }
        boolean merged = false;
        int Nstep = size;
        while (Nstep > 0) {
            min12 = Double.MAX_VALUE;
            if (!merged) {
                for (int i = 0; i < size - 1; ++i) {
                    if (this.is_consider[i] <= 0) continue;
                    for (int j = i + 1; j < size; ++j) {
                        if (this.is_consider[j] <= 0 || !((double)this.ktdistance12[i][j] < min12)) continue;
                        min12 = this.ktdistance12[i][j];
                        j1 = i;
                        j2 = j;
                    }
                }
            } else {
                for (int j = 0; j < size; ++j) {
                    if (this.is_consider[j] <= 0 || j == j1 || !((double)this.ktdistance12[j1][j] < min12)) continue;
                    min12 = this.ktdistance12[j1][j];
                    j2 = j;
                }
            }
            if (!merged && Nstep == 1) break;
            double min1 = this.ktdistance1[j1];
            if ((double)this.ktdistance1[j2] < min1) {
                min1 = this.ktdistance1[j2];
            }
            merged = false;
            if (min12 < min1) {
                merged = true;
            }
            if (merged) {
                ParticleF p12 = list.get(j1);
                ParticleF p2 = list.get(j2);
                if (j1 != j2) {
                    p12.add(p2);
                }
                --Nstep;
                list.set(j1, p12);
                this.is_consider[j2] = 0;
                this.is_consider[j1] = this.is_consider[j1] + 1;
                this.ktdistance1[j1] = this.getKtDistance1(p12);
                for (int i = 0; i < size; ++i) {
                    if (this.is_consider[i] <= 0 || i == j1) continue;
                    ParticleF pp1 = list.get(i);
                    this.ktdistance12[j1][i] = this.getKtDistance12(p12, pp1);
                }
            }
            if (merged) continue;
            this.is_consider[j1] = -1;
            ParticleF pj = list.get(j1);
            --Nstep;
            if (!((double)pj.getEt() > this.minpt)) continue;
            this.jets.add(pj);
        }
        if (this.debug) {
            int ins = -1;
            for (int i = 0; i < size; ++i) {
                if (this.is_consider[i] != 1) continue;
                ins = i;
            }
            if (ins > -1) {
                ParticleF p2 = list.get(ins);
                if (this.debug) {
                    System.out.println("Unmerged particle id=" + Integer.toString(ins));
                }
                min12 = Double.MAX_VALUE;
                for (int j = 0; j < this.jets.size(); ++j) {
                    ParticleF lp = this.jets.get(j);
                    float d = this.getDistance(p2, lp);
                    if (!((double)d < min12)) continue;
                    j1 = j;
                    min12 = d;
                }
                if (this.debug) {
                    System.out.println("Distance R to closest jet=" + Double.toString(min12));
                }
                if (min12 < (double)R) {
                    if (this.debug) {
                        System.out.println(" --> Particle merged");
                    }
                    ParticleF lp = this.jets.get(j1);
                    lp.add(p2);
                    this.is_consider[ins] = 0;
                }
            }
            int nn = 0;
            ins = -1;
            for (int i = 0; i < size; ++i) {
                if (this.is_consider[i] != 1) continue;
                ++nn;
                ins = i;
            }
            if (nn != 0) {
                System.out.println("--> WARNING: particle with ID=" + Integer.toString(ins) + " unmerged");
            }
            long stopTime2 = System.currentTimeMillis();
            long runTime = stopTime2 - startTime;
            System.out.println("  --> Final time for calculation (ms): " + runTime);
            System.out.println("  --> Nr of jets : " + this.jets.size());
        }
        if (this.debug) {
            long stopTime2 = System.currentTimeMillis();
            long runTime = stopTime2 - startTime;
            System.out.println("  --> Final time for calculation (ms): " + runTime);
        }
        this.is_consider = null;
        this.ktdistance12 = null;
        this.ktdistance1 = null;
        return this.jets;
    }

    public ArrayList<ParticleF> getJetsSorted() {
        Collections.sort(this.jets);
        return this.jets;
    }

    public void printJets() {
        ArrayList<ParticleF> sjets = this.getJetsSorted();
        System.out.println("# Nr of jets=" + Integer.toString(sjets.size()));
        System.out.format("%5s %14s %14s %14s \n", "jet #", "Eta", "phi", "Et");
        for (int i = 0; i < sjets.size(); ++i) {
            ParticleF lp = sjets.get(i);
            double phi = lp.getPhi();
            if (phi < 0.0) {
                phi = 6.2831854820251465 + phi;
            }
            String s1 = String.format("%15.8f", Float.valueOf(lp.getEta()));
            String s2 = String.format("%15.8f", phi);
            String s3 = String.format("%15.8f", Float.valueOf(lp.getEt()));
            System.out.format("%5s%15s%15s%15s\n", Integer.toString(i), s1, s2, s3);
        }
    }

    public String toString() {
        ArrayList<ParticleF> sjets = this.getJetsSorted();
        String tmp = "# Nr of jets=" + Integer.toString(sjets.size()) + "\n";
        for (int i = 0; i < sjets.size(); ++i) {
            ParticleF lp = sjets.get(i);
            String spx = this.formatter.format(lp.getEta());
            String spy = this.formatter.format(lp.getPhi());
            String spz = this.formatter.format(lp.getEt());
            tmp = tmp + "n=" + Integer.toString(i) + " eta=" + spx + " phi=" + spy + " et=" + spz + "\n";
        }
        return tmp;
    }

    public float getKtDistance12(ParticleF a, ParticleF b) {
        double deltaEta = a.getEta() - b.getEta();
        double phi1 = a.getPhi();
        double phi2 = b.getPhi();
        double deltaPhi = phi2 - phi1;
        if (deltaPhi > Math.PI) {
            deltaPhi = 6.2831854820251465 - deltaPhi;
        }
        if (deltaPhi < -Math.PI) {
            deltaPhi = 6.2831854820251465 + deltaPhi;
        }
        double rsq = deltaEta * deltaEta + deltaPhi * deltaPhi;
        double esq = 0.0;
        esq = mode == 1 ? (double)Math.min(a.getEt2(), b.getEt2()) : (mode == 0 ? (double)Math.min(a.getEt(), b.getEt()) : (mode == -1 ? Math.min(1.0 / (double)a.getEt2(), 1.0 / (double)b.getEt2()) : (double)Math.min(a.getEt2(), b.getEt2())));
        return (float)(esq * rsq / (double)R2);
    }

    public float getDistance(ParticleF a, ParticleF b) {
        double deltaEta = a.getEta() - b.getEta();
        double phi1 = a.getPhi();
        double phi2 = b.getPhi();
        double deltaPhi = phi2 - phi1;
        if (deltaPhi > Math.PI) {
            deltaPhi = 6.2831854820251465 - deltaPhi;
        }
        if (deltaPhi < -Math.PI) {
            deltaPhi = 6.2831854820251465 + deltaPhi;
        }
        double rsq = deltaEta * deltaEta + deltaPhi * deltaPhi;
        return (float)Math.sqrt(rsq);
    }

    public float getKtDistance1(ParticleF a) {
        if (mode == 1) {
            return a.getEt2();
        }
        if (mode == 0) {
            return a.getEt();
        }
        if (mode == -1) {
            return (float)(1.0 / (double)a.getEt2());
        }
        return a.getEt2();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 3; ++i) {
            ArrayList<ParticleF> list = new ArrayList<ParticleF>();
            try {
                String line;
                File file = new File("jets/single-event.dat");
                System.out.println("Reading test file with jets. Number of particles:");
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((line = bufferedReader.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line);
                    int j = 0;
                    double[] mom = new double[4];
                    while (st.hasMoreElements()) {
                        Double d = Double.parseDouble(st.nextElement().toString());
                        mom[j] = d;
                        ++j;
                    }
                    ParticleF pp = new ParticleF();
                    pp.setPxPyPzE((float)mom[0], (float)mom[1], (float)mom[2], (float)mom[3]);
                    list.add(pp);
                }
                fileReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            KTjet ktjet = new KTjet(0.6, 1, -1, 5.0);
            ktjet.setDebug(true);
            ktjet.buildJets(list);
            ktjet.printJets();
        }
    }

    static {
        mode = 1;
    }
}

