/*
 * Decompiled with CFR 0.152.
 */
package visad.test;

import java.awt.BorderLayout;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GridCoordinateSystem;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.util.Util;

public class ImageAnimationTest
extends JPanel {
    ImageRendererJ3D imgRend;

    public static final float[] makeSinusoidalSamples(int lenX, int lenY, int waveNum) {
        float[] samples = new float[lenX * lenY];
        int index = 0;
        double PI = Math.PI;
        for (int ii = 0; ii < lenX; ++ii) {
            for (int jj = 0; jj < lenY; ++jj) {
                samples[index] = (float)(Math.sin((double)waveNum * PI / 100.0 * (double)jj) * Math.sin((double)waveNum * PI / 100.0 * (double)ii));
                ++index;
            }
        }
        return samples;
    }

    protected float[][] makeSamples(int size, int num) {
        float[][] samples = new float[num][size ^ 2];
        for (int i = 0; i < num; ++i) {
            samples[i] = ImageAnimationTest.makeSinusoidalSamples(size, size, i);
        }
        return samples;
    }

    public ImageAnimationTest(int num, int size) throws VisADException, RemoteException {
        RealTupleType pxlA = new RealTupleType(RealType.getRealType("x_a"), RealType.getRealType("y_a"));
        Linear2DSet set = new Linear2DSet((MathType)RealTupleType.Generic2D, 0.0, (double)(size - 1), size, 0.0, size - 1, size);
        float[][] locs = set.getSamples();
        Gridded2DSet locs_set = new Gridded2DSet((MathType)pxlA, locs, size, size);
        GridCoordinateSystem gcs = new GridCoordinateSystem(locs_set);
        RealTupleType pxl = new RealTupleType(RealType.getRealType("x"), RealType.getRealType("y"), gcs, null);
        Linear2DSet imgSet = new Linear2DSet((MathType)pxl, 0.0, (double)(size - 1), size, 0.0, size - 1, size);
        FunctionType pxlVal = new FunctionType(pxl, RealType.getRealType("val"));
        FunctionType timePxlVal = new FunctionType(RealType.Time, pxlVal);
        FieldImpl timeFld = new FieldImpl(timePxlVal, new Integer1DSet((MathType)RealType.Time, num));
        float[][] samples = this.makeSamples(size, num);
        for (int i = 0; i < samples.length; ++i) {
            FlatField imgFld = new FlatField(pxlVal, imgSet);
            imgFld.setSamples(new float[][]{samples[i]}, false);
            timeFld.setSample(i, (Data)imgFld, false);
        }
        System.out.println("makeSamples done");
        DataReferenceImpl ref = new DataReferenceImpl("image");
        ref.setData(timeFld);
        DisplayImplJ3D display = new DisplayImplJ3D("image display");
        this.imgRend = new ImageRendererJ3D();
        System.err.println("Renderer:" + this.imgRend.toString());
        display.addMap(new ScalarMap(RealType.getRealType("x_a"), Display.XAxis));
        display.addMap(new ScalarMap(RealType.getRealType("y_a"), Display.YAxis));
        display.addMap(new ScalarMap(RealType.getRealType("val"), Display.RGB));
        ScalarMap aniMap = new ScalarMap(RealType.Time, Display.Animation);
        display.addMap(aniMap);
        AnimationControl aniCtrl = (AnimationControl)((Object)aniMap.getControl());
        aniCtrl.setStep(500);
        aniCtrl.setOn(true);
        display.addReferences((DataRenderer)this.imgRend, ref);
        this.setLayout(new BorderLayout());
        this.add(display.getComponent());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        int num = 0;
        int size = 0;
        try {
            num = Integer.parseInt(args[0]);
            size = Integer.parseInt(args[1]);
        }
        catch (Exception e) {
            System.err.println("USAGE: ImageAnimationTest <numImgs> <size>");
            System.exit(1);
        }
        Util.printJ3DProperties(null);
        JFrame frame = new JFrame("Image Animation Test");
        frame.setDefaultCloseOperation(3);
        frame.setLayout(new BorderLayout());
        ImageAnimationTest aniTest = new ImageAnimationTest(num, size);
        frame.add(aniTest);
        frame.setSize(600, 600);
        frame.setVisible(true);
    }
}

