/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ColorControl;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Linear2DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.java2d.DefaultRendererJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;

public class TestArea {
    static boolean use2D = false;
    static String imageSource = "AREA0007";
    static String band = "1";
    static String mapfile = "OUTLUSAM";

    private static boolean getOptions(String[] args) {
        boolean defaultFile = true;
        boolean defaultBand = true;
        boolean defaultMap = true;
        int keyNum = 0;
        boolean gotValidOptions = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                switch (args[i].charAt(1)) {
                    case '2': {
                        use2D = true;
                        break;
                    }
                    case '3': {
                        use2D = false;
                        break;
                    }
                    case 'f': {
                        imageSource = args[++i];
                        defaultFile = false;
                        break;
                    }
                    case 'b': {
                        band = args[++i];
                        defaultBand = false;
                        break;
                    }
                    case 'm': {
                        mapfile = args[++i];
                        defaultMap = false;
                        break;
                    }
                    default: {
                        System.err.println("Unknown option \"" + args[i] + "\"");
                        gotValidOptions = true;
                        break;
                    }
                }
                continue;
            }
            switch (keyNum) {
                case 0: {
                    imageSource = args[i];
                    defaultFile = false;
                    break;
                }
                case 1: {
                    band = args[i];
                    defaultBand = false;
                    break;
                }
                case 2: {
                    mapfile = args[i];
                    defaultMap = false;
                    break;
                }
                default: {
                    System.err.println("Unknown keyword \"" + args[i] + "\"");
                    gotValidOptions = true;
                }
            }
            ++keyNum;
        }
        if (!gotValidOptions) {
            System.err.print("Usage: java TestArea ");
            System.err.print(" <AREAfilename>");
            System.err.print(" <band#>");
            System.err.print(" <mapfilename>");
            System.err.println("");
            System.err.print("  or : java TestArea");
            System.err.print(" [-2(D)|-3(D)]");
            System.err.print(" [-f AREAfilename]");
            System.err.print(" [-b band#]");
            System.err.print(" [-m mapfilename]");
            System.err.println("");
            System.err.println("\t(filenames may also be URLs)");
        }
        if (defaultFile || defaultBand || defaultMap) {
            boolean needComma = false;
            System.out.print("Using default");
            if (defaultFile) {
                System.out.print((needComma ? "," : "") + " file " + imageSource);
            }
            if (defaultBand) {
                System.out.print((needComma ? "," : "") + " band " + band);
            }
            if (defaultMap) {
                System.out.print((needComma ? "," : "") + " map " + mapfile);
            }
            System.out.println("");
        }
        return gotValidOptions;
    }

    public static void main(String[] args) {
        if (!TestArea.getOptions(args)) {
            System.exit(1);
            return;
        }
        FlatField imaget = null;
        System.out.println("Reading AREA file \"" + imageSource + "\"");
        AreaAdapter aa = null;
        try {
            aa = new AreaAdapter(imageSource);
        }
        catch (Exception e) {
            System.err.println("Caught IOException for \"" + imageSource + "\": " + e.getMessage());
            System.exit(1);
        }
        imaget = aa.getData();
        if (imaget == null) {
            System.out.println("\tNULL FlatField!");
        } else {
            System.out.println("\t" + imaget.getType());
        }
        int bandNumber = Integer.parseInt(band.trim());
        try {
            System.out.println("DateTime= " + aa.getNominalTime());
            System.out.println("imaget.getDomainSet()=" + imaget.getDomainSet());
            System.out.println("imaget.getDomain.getType=" + imaget.getDomainSet().getType());
            int[] dim = aa.getDimensions();
            int numEles = dim[1];
            int numLines = dim[2];
            System.out.println("Creating basemap overlay from \"" + mapfile + "\"");
            BaseMapAdapter bma = mapfile.indexOf("://") > 0 ? new BaseMapAdapter(new URL(mapfile)) : new BaseMapAdapter(mapfile);
            bma.setDomainSet((Linear2DSet)imaget.getDomainSet());
            DataReferenceImpl maplines_ref = new DataReferenceImpl("MapLines");
            maplines_ref.setData(bma.getData());
            DisplayImpl display = use2D ? new DisplayImplJ2D("display1") : new DisplayImplJ3D("display1");
            System.out.println("Starting to render display");
            FunctionType ftype = (FunctionType)imaget.getType();
            RealTupleType dtype = ftype.getDomain();
            RealTupleType rtype = (RealTupleType)ftype.getRange();
            ScalarMap xaxis = new ScalarMap((RealType)dtype.getComponent(0), Display.XAxis);
            xaxis.setRange(0.0, numEles);
            ScalarMap yaxis = new ScalarMap((RealType)dtype.getComponent(1), Display.YAxis);
            yaxis.setRange(0.0, numLines);
            display.addMap(xaxis);
            display.addMap(yaxis);
            ScalarMap rgbMap = new ScalarMap((RealType)rtype.getComponent(bandNumber - 1), Display.RGB);
            display.addMap(rgbMap);
            ColorControl cc = (ColorControl)rgbMap.getControl();
            cc.initGreyWedge();
            DataReferenceImpl ref_image = new DataReferenceImpl("ref_image");
            ref_image.setData(imaget);
            display.addReference(ref_image, null);
            ConstantMap[] redMap = use2D ? new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green)} : new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.01, Display.ZAxis)};
            DataRenderer drend = use2D ? new DefaultRendererJ2D() : new DefaultRendererJ3D();
            display.addReferences(drend, maplines_ref, redMap);
            JFrame jframe = new JFrame("McIDAS AREA in Java 3D");
            jframe.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            jframe.setContentPane((JPanel)display.getComponent());
            jframe.setSize(numEles, numLines);
            jframe.setVisible(true);
        }
        catch (Exception xxx) {
            System.out.println("Ex: " + xxx);
            System.exit(1);
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(5000L);
                }
            }
            catch (Exception e) {
                System.exit(0);
                continue;
            }
            break;
        }
    }
}

